<?php
/**
 * Randevu Sistemi V7 - Konfigürasyon Dosyası
 * o2nar.com/test
 */

// Hata raporlama (geliştirme için açık, canlıda kapat)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Zaman dilimi
date_default_timezone_set('Europe/Istanbul');

// Session başlat
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Veritabanı ayarları
define('DB_HOST', 'localhost');
define('DB_NAME', 'veritabani_adi');  // Kendi veritabanı adınızı yazın
define('DB_USER', 'kullanici_adi');   // Kendi kullanıcı adınızı yazın
define('DB_PASS', 'sifre');           // Kendi şifrenizi yazın
define('DB_CHARSET', 'utf8mb4');

// Site ayarları
define('SITE_URL', 'https://o2nar.com/test');
define('ADMIN_URL', SITE_URL . '/admin');
define('API_URL', SITE_URL . '/api');

// Klinik bilgileri
define('CLINIC_NAME', 'Özgür Oktay Nar Muayenehanesi');
define('CLINIC_ADDRESS', 'Adres bilgisi');
define('CLINIC_PHONE', '+90 XXX XXX XX XX');
define('CLINIC_EMAIL', 'info@o2nar.com');

// Çalışma saatleri
define('WORKING_HOURS_START', '08:00');
define('WORKING_HOURS_END', '18:00');
define('SLOT_DURATION', 15); // dakika

// SMS/WhatsApp ayarları (Netgsm)
define('NETGSM_USERCODE', '');
define('NETGSM_PASSWORD', '');
define('NETGSM_HEADER', '');
define('SMS_ENABLED', true);
define('WHATSAPP_ENABLED', true);

// Randevu kuralları
define('MAX_ADVANCE_DAYS', 60);      // Kaç gün sonrasına randevu alınabilir
define('MIN_ADVANCE_HOURS', 2);      // En az kaç saat önceden randevu alınabilir
define('CANCELLATION_HOURS', 24);    // Kaç saat öncesine kadar iptal edilebilir

// PDO Veritabanı bağlantısı
class Database {
    private static $instance = null;
    private $pdo;
    
    private function __construct() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            $this->pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            die("Veritabanı bağlantı hatası: " . $e->getMessage());
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->pdo;
    }
}

// Kısa yol fonksiyonu
function db() {
    return Database::getInstance()->getConnection();
}

// CSRF Token
function generateCSRFToken() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verifyCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// JSON Response helper
function jsonResponse($data, $status = 200) {
    http_response_code($status);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

// Tarih formatlama
function formatDate($date, $format = 'd.m.Y') {
    if (empty($date)) return '-';
    return date($format, strtotime($date));
}

function formatTime($time, $format = 'H:i') {
    if (empty($time)) return '-';
    return date($format, strtotime($time));
}

function formatDateTime($datetime, $format = 'd.m.Y H:i') {
    if (empty($datetime)) return '-';
    return date($format, strtotime($datetime));
}

// Telefon numarası normalize
function normalizePhone($phone) {
    $phone = preg_replace('/[^0-9+]/', '', $phone);
    if (substr($phone, 0, 1) === '0') {
        $phone = '+90' . substr($phone, 1);
    } elseif (substr($phone, 0, 2) === '90') {
        $phone = '+' . $phone;
    } elseif (substr($phone, 0, 1) !== '+') {
        $phone = '+90' . $phone;
    }
    return $phone;
}

// XSS koruması
function e($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// Slug oluştur
function slugify($text) {
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    $text = preg_replace('~-+~', '-', $text);
    $text = strtolower($text);
    return $text;
}
