<?php
/**
 * Randevu Sistemi V7 - Kimlik Doğrulama
 */

require_once __DIR__ . '/config.php';

// Giriş kontrolü
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

// Admin mi kontrolü
function isAdmin() {
    return isLoggedIn() && isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

// Super admin mi kontrolü
function isSuperAdmin() {
    return isLoggedIn() && isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'super_admin';
}

// Giriş zorunlu
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: ' . ADMIN_URL . '/login.php');
        exit;
    }
}

// Admin girişi zorunlu
function requireAdmin() {
    requireLogin();
    if (!isAdmin() && !isSuperAdmin()) {
        header('Location: ' . ADMIN_URL . '/login.php?error=unauthorized');
        exit;
    }
}

// Kullanıcı girişi
function login($email, $password) {
    $stmt = db()->prepare("
        SELECT id, first_name, last_name, email, password, role, is_active, color 
        FROM staff 
        WHERE email = ? AND is_active = 1
    ");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['first_name'] . ' ' . $user['last_name'];
        $_SESSION['user_email'] = $user['email'];
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['user_color'] = $user['color'];
        
        // Son giriş zamanını güncelle
        $stmt = db()->prepare("UPDATE staff SET last_login = NOW() WHERE id = ?");
        $stmt->execute([$user['id']]);
        
        return true;
    }
    
    return false;
}

// Çıkış
function logout() {
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}

// Mevcut kullanıcı bilgisi
function currentUser() {
    if (!isLoggedIn()) return null;
    
    return [
        'id' => $_SESSION['user_id'],
        'name' => $_SESSION['user_name'],
        'email' => $_SESSION['user_email'],
        'role' => $_SESSION['user_role'],
        'color' => $_SESSION['user_color'] ?? '#3b82f6'
    ];
}

// Şifre hashleme
function hashPassword($password) {
    return password_hash($password, PASSWORD_DEFAULT);
}
