-- =====================================================
-- RANDEVU SİSTEMİ V7 - VERİTABANI ŞEMASI
-- o2nar.com/test
-- =====================================================

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- -----------------------------------------------------
-- Personel Tablosu (Admin + Doktorlar)
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `staff` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `first_name` VARCHAR(100) NOT NULL,
    `last_name` VARCHAR(100) NOT NULL,
    `email` VARCHAR(255) NOT NULL UNIQUE,
    `password` VARCHAR(255) NOT NULL,
    `phone` VARCHAR(20) DEFAULT NULL,
    `role` ENUM('super_admin', 'admin', 'staff') DEFAULT 'staff',
    `title` VARCHAR(100) DEFAULT NULL COMMENT 'Dr., Fzt., Pod. vb.',
    `specialty` VARCHAR(255) DEFAULT NULL,
    `color` VARCHAR(7) DEFAULT '#3b82f6',
    `avatar` VARCHAR(255) DEFAULT NULL,
    `is_active` TINYINT(1) DEFAULT 1,
    `sort_order` INT DEFAULT 0,
    `working_hours` JSON DEFAULT NULL COMMENT 'Çalışma saatleri',
    `last_login` DATETIME DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_email` (`email`),
    INDEX `idx_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Varsayılan personel (şifre: 123456)
INSERT INTO `staff` (`first_name`, `last_name`, `email`, `password`, `role`, `title`, `color`, `sort_order`) VALUES
('Özgür Oktay', 'NAR', 'ozgur@o2nar.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'super_admin', 'Dr.', '#3b82f6', 1),
('Gül', 'GÜNER NAR', 'gul@o2nar.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'Dr.', '#ec4899', 2),
('Haydar', 'KESER', 'haydar@o2nar.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'staff', 'Fzt.', '#22c55e', 3),
('Nurgül', 'ERATAN', 'nurgul@o2nar.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'staff', 'Pod.', '#f59e0b', 4)
ON DUPLICATE KEY UPDATE `first_name` = VALUES(`first_name`);

-- -----------------------------------------------------
-- Hizmet Kategorileri
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `service_categories` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(100) NOT NULL,
    `description` TEXT,
    `sort_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `service_categories` (`id`, `name`, `sort_order`) VALUES
(1, 'Ortopedi ve Travmatoloji', 1),
(2, 'Pediatri', 2),
(3, 'Fizik Tedavi', 3),
(4, 'Podoloji', 4)
ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);

-- -----------------------------------------------------
-- Hizmetler
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `services` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `category_id` INT UNSIGNED NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `description` TEXT,
    `duration` INT NOT NULL DEFAULT 30 COMMENT 'Dakika',
    `price` DECIMAL(10,2) DEFAULT 0.00,
    `color` VARCHAR(7) DEFAULT '#3b82f6',
    `is_active` TINYINT(1) DEFAULT 1,
    `is_online_bookable` TINYINT(1) DEFAULT 1,
    `sort_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (`category_id`) REFERENCES `service_categories`(`id`) ON DELETE RESTRICT,
    INDEX `idx_category` (`category_id`),
    INDEX `idx_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `services` (`category_id`, `name`, `duration`, `color`, `sort_order`) VALUES
(1, 'Kontrol Randevusu', 15, '#3b82f6', 1),
(1, 'Ortopedi Muayenesi', 30, '#1d4ed8', 2),
(1, 'PRP Tedavisi', 45, '#7c3aed', 3),
(1, 'Kök Hücre Tedavisi', 60, '#6366f1', 4),
(1, 'Minimal İnvaziv Cerrahi', 60, '#4f46e5', 5),
(2, 'Pediatri Muayenesi', 20, '#ec4899', 6),
(3, 'Fizik Tedavi Seansı', 45, '#22c55e', 7),
(3, 'Sporcu Rehabilitasyonu', 45, '#16a34a', 8),
(4, 'Podoloji İşlem', 30, '#f59e0b', 9)
ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);

-- -----------------------------------------------------
-- Personel-Hizmet İlişkisi
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `staff_services` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `staff_id` INT UNSIGNED NOT NULL,
    `service_id` INT UNSIGNED NOT NULL,
    `custom_duration` INT DEFAULT NULL,
    `custom_price` DECIMAL(10,2) DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`staff_id`) REFERENCES `staff`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`service_id`) REFERENCES `services`(`id`) ON DELETE CASCADE,
    UNIQUE KEY `unique_staff_service` (`staff_id`, `service_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Varsayılan personel-hizmet eşleşmeleri
INSERT INTO `staff_services` (`staff_id`, `service_id`) VALUES
(1, 1), (1, 2), (1, 3), (1, 4), (1, 5),
(2, 6),
(3, 7), (3, 8),
(4, 9)
ON DUPLICATE KEY UPDATE `staff_id` = VALUES(`staff_id`);

-- -----------------------------------------------------
-- Hastalar
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `patients` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `first_name` VARCHAR(100) NOT NULL,
    `last_name` VARCHAR(100) DEFAULT NULL,
    `email` VARCHAR(255) DEFAULT NULL,
    `phone` VARCHAR(20) NOT NULL,
    `birth_date` DATE DEFAULT NULL,
    `gender` ENUM('male', 'female', 'other') DEFAULT NULL,
    `tc_no` VARCHAR(11) DEFAULT NULL,
    `address` TEXT,
    `city` VARCHAR(100) DEFAULT NULL,
    `notes` TEXT COMMENT 'Genel hasta notları',
    `source` ENUM('online', 'phone', 'walk_in', 'referral', 'ad', 'hospital', 'import') DEFAULT 'online',
    `is_blocked` TINYINT(1) DEFAULT 0,
    `block_reason` VARCHAR(255) DEFAULT NULL,
    `sms_enabled` TINYINT(1) DEFAULT 1,
    `whatsapp_enabled` TINYINT(1) DEFAULT 1,
    `email_enabled` TINYINT(1) DEFAULT 1,
    `last_appointment_at` DATETIME DEFAULT NULL,
    `total_appointments` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_phone` (`phone`),
    INDEX `idx_email` (`email`),
    INDEX `idx_tc` (`tc_no`),
    INDEX `idx_blocked` (`is_blocked`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Hasta Etiketleri
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `patient_tags` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(50) NOT NULL UNIQUE,
    `color` VARCHAR(7) DEFAULT '#6B7280',
    `description` VARCHAR(255) DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `patient_tags` (`name`, `color`, `description`) VALUES
('VIP', '#F59E0B', 'Özel ilgi gerektiren hasta'),
('Düzenli', '#10B981', 'Düzenli gelen hasta'),
('Yeni', '#3B82F6', 'Yeni kayıtlı hasta'),
('Sorunlu', '#EF4444', 'Dikkat gerektiren hasta'),
('Kurumsal', '#8B5CF6', 'Kurumsal/Sigorta hastası'),
('Referans', '#EC4899', 'Referans ile gelen'),
('Çocuk', '#F472B6', '18 yaş altı'),
('Yaşlı', '#6B7280', '65 yaş üstü'),
('Sporcu', '#06B6D4', 'Profesyonel sporcu')
ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);

-- -----------------------------------------------------
-- Hasta-Etiket İlişkisi
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `patient_tag_relations` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `patient_id` INT UNSIGNED NOT NULL,
    `tag_id` INT UNSIGNED NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`patient_id`) REFERENCES `patients`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`tag_id`) REFERENCES `patient_tags`(`id`) ON DELETE CASCADE,
    UNIQUE KEY `unique_patient_tag` (`patient_id`, `tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Hasta Notları (Kategorili)
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `patient_notes` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `patient_id` INT UNSIGNED NOT NULL,
    `note` TEXT NOT NULL,
    `note_type` ENUM('general', 'medical', 'billing', 'complaint', 'allergy', 'other') DEFAULT 'general',
    `is_private` TINYINT(1) DEFAULT 0,
    `created_by` INT UNSIGNED DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`patient_id`) REFERENCES `patients`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`created_by`) REFERENCES `staff`(`id`) ON DELETE SET NULL,
    INDEX `idx_patient` (`patient_id`),
    INDEX `idx_type` (`note_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Hasta İletişim Geçmişi
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `patient_communications` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `patient_id` INT UNSIGNED NOT NULL,
    `type` ENUM('sms', 'whatsapp', 'email', 'call', 'other') NOT NULL,
    `direction` ENUM('incoming', 'outgoing') DEFAULT 'outgoing',
    `subject` VARCHAR(255) DEFAULT NULL,
    `message` TEXT,
    `status` ENUM('pending', 'sent', 'delivered', 'read', 'failed') DEFAULT 'sent',
    `sent_by` INT UNSIGNED DEFAULT NULL,
    `external_id` VARCHAR(100) DEFAULT NULL COMMENT 'SMS/WhatsApp API ID',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`patient_id`) REFERENCES `patients`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`sent_by`) REFERENCES `staff`(`id`) ON DELETE SET NULL,
    INDEX `idx_patient` (`patient_id`),
    INDEX `idx_type` (`type`),
    INDEX `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Randevular
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `appointments` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `patient_id` INT UNSIGNED NOT NULL,
    `staff_id` INT UNSIGNED NOT NULL,
    `service_id` INT UNSIGNED NOT NULL,
    `appointment_date` DATE NOT NULL,
    `start_time` TIME NOT NULL,
    `end_time` TIME NOT NULL,
    `duration` INT NOT NULL COMMENT 'Dakika',
    `status` ENUM('pending', 'confirmed', 'completed', 'cancelled', 'no_show') DEFAULT 'pending',
    `notes` TEXT COMMENT 'Randevu notları',
    `internal_notes` TEXT COMMENT 'Dahili notlar (hasta görmez)',
    `cancellation_reason` VARCHAR(255) DEFAULT NULL,
    `cancelled_at` DATETIME DEFAULT NULL,
    `cancelled_by` INT UNSIGNED DEFAULT NULL,
    `reminder_sent` TINYINT(1) DEFAULT 0,
    `reminder_sent_at` DATETIME DEFAULT NULL,
    `confirmation_sent` TINYINT(1) DEFAULT 0,
    `source` ENUM('online', 'phone', 'walk_in', 'admin') DEFAULT 'online',
    `created_by` INT UNSIGNED DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (`patient_id`) REFERENCES `patients`(`id`) ON DELETE RESTRICT,
    FOREIGN KEY (`staff_id`) REFERENCES `staff`(`id`) ON DELETE RESTRICT,
    FOREIGN KEY (`service_id`) REFERENCES `services`(`id`) ON DELETE RESTRICT,
    INDEX `idx_date` (`appointment_date`),
    INDEX `idx_staff_date` (`staff_id`, `appointment_date`),
    INDEX `idx_patient` (`patient_id`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Bloke Zamanlar
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `blocked_times` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `staff_id` INT UNSIGNED NOT NULL,
    `block_date` DATE NOT NULL,
    `start_time` TIME NOT NULL,
    `end_time` TIME NOT NULL,
    `block_type` ENUM('break', 'leave', 'meeting', 'other') DEFAULT 'other',
    `reason` VARCHAR(255) DEFAULT NULL,
    `is_recurring` TINYINT(1) DEFAULT 0,
    `recurring_pattern` JSON DEFAULT NULL,
    `created_by` INT UNSIGNED DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`staff_id`) REFERENCES `staff`(`id`) ON DELETE CASCADE,
    INDEX `idx_staff_date` (`staff_id`, `block_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Mesaj Şablonları
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `message_templates` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(100) NOT NULL,
    `type` ENUM('sms', 'whatsapp', 'email') NOT NULL,
    `subject` VARCHAR(255) DEFAULT NULL,
    `content` TEXT NOT NULL,
    `variables` JSON DEFAULT NULL COMMENT 'Kullanılabilir değişkenler',
    `is_default` TINYINT(1) DEFAULT 0,
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `message_templates` (`name`, `type`, `content`, `is_default`) VALUES
('Randevu Onay', 'sms', 'Sayın {patientName}, {date} tarihinde saat {time} için {doctorName} ile randevunuz oluşturulmuştur. {clinicName}', 1),
('Randevu Hatırlatma', 'sms', 'Sayın {patientName}, yarın saat {time} için {doctorName} ile randevunuz bulunmaktadır. {clinicName}', 0),
('Randevu İptal', 'sms', 'Sayın {patientName}, {date} tarihli randevunuz iptal edilmiştir. Yeni randevu için bizi arayabilirsiniz. {clinicName}', 0),
('Doğum Günü', 'sms', 'Sayın {patientName}, doğum gününüzü kutlar, sağlıklı nice yıllar dileriz. {clinicName}', 0)
ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);

-- -----------------------------------------------------
-- Bildirim Logları
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `notification_logs` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `patient_id` INT UNSIGNED DEFAULT NULL,
    `appointment_id` INT UNSIGNED DEFAULT NULL,
    `template_id` INT UNSIGNED DEFAULT NULL,
    `type` ENUM('sms', 'whatsapp', 'email') NOT NULL,
    `recipient` VARCHAR(255) NOT NULL,
    `content` TEXT NOT NULL,
    `status` ENUM('pending', 'sent', 'delivered', 'failed') DEFAULT 'pending',
    `error_message` VARCHAR(255) DEFAULT NULL,
    `external_id` VARCHAR(100) DEFAULT NULL,
    `sent_at` DATETIME DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_patient` (`patient_id`),
    INDEX `idx_appointment` (`appointment_id`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Sistem Ayarları
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `settings` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `key` VARCHAR(100) NOT NULL UNIQUE,
    `value` TEXT,
    `type` ENUM('string', 'number', 'boolean', 'json') DEFAULT 'string',
    `description` VARCHAR(255) DEFAULT NULL,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `settings` (`key`, `value`, `type`, `description`) VALUES
('clinic_name', 'Özgür Oktay Nar Muayenehanesi', 'string', 'Klinik adı'),
('working_hours_start', '08:00', 'string', 'Çalışma başlangıç saati'),
('working_hours_end', '18:00', 'string', 'Çalışma bitiş saati'),
('slot_duration', '15', 'number', 'Slot süresi (dakika)'),
('max_advance_days', '60', 'number', 'Maksimum ileri randevu günü'),
('min_advance_hours', '2', 'number', 'Minimum randevu öncesi saat'),
('sms_enabled', '1', 'boolean', 'SMS bildirimleri aktif'),
('whatsapp_enabled', '1', 'boolean', 'WhatsApp bildirimleri aktif'),
('auto_reminder_hours', '24', 'number', 'Otomatik hatırlatma (saat önce)')
ON DUPLICATE KEY UPDATE `key` = VALUES(`key`);

SET FOREIGN_KEY_CHECKS = 1;

-- =====================================================
-- KURULUM TAMAMLANDI!
-- =====================================================
