<?php
/**
 * Randevu Sistemi V7 - Hasta Notları API
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once __DIR__ . '/../includes/config.php';

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            getNotes();
            break;
        case 'POST':
            createNote();
            break;
        case 'DELETE':
            deleteNote();
            break;
        default:
            jsonResponse(['error' => 'Method not allowed'], 405);
    }
} catch (Exception $e) {
    jsonResponse(['error' => $e->getMessage()], 500);
}

function getNotes() {
    $patientId = $_GET['patient_id'] ?? null;
    
    if (!$patientId) {
        jsonResponse(['error' => 'patient_id gerekli'], 400);
    }
    
    $sql = "
        SELECT pn.*, CONCAT(s.first_name, ' ', s.last_name) as created_by_name
        FROM patient_notes pn
        LEFT JOIN staff s ON pn.created_by = s.id
        WHERE pn.patient_id = ?
        ORDER BY pn.created_at DESC
    ";
    
    $stmt = db()->prepare($sql);
    $stmt->execute([$patientId]);
    
    jsonResponse([
        'success' => true,
        'notes' => $stmt->fetchAll()
    ]);
}

function createNote() {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (empty($data['patient_id']) || empty($data['note'])) {
        jsonResponse(['error' => 'patient_id ve note gerekli'], 400);
    }
    
    // Oturumdaki kullanıcı ID'si (varsa)
    session_start();
    $createdBy = $_SESSION['user_id'] ?? null;
    
    $sql = "
        INSERT INTO patient_notes (patient_id, note, note_type, created_by, created_at)
        VALUES (?, ?, ?, ?, NOW())
    ";
    
    $stmt = db()->prepare($sql);
    $stmt->execute([
        $data['patient_id'],
        $data['note'],
        $data['note_type'] ?? 'general',
        $createdBy
    ]);
    
    jsonResponse([
        'success' => true,
        'id' => db()->lastInsertId(),
        'message' => 'Not eklendi'
    ]);
}

function deleteNote() {
    $id = $_GET['id'] ?? null;
    
    if (!$id) {
        jsonResponse(['error' => 'ID gerekli'], 400);
    }
    
    $stmt = db()->prepare("DELETE FROM patient_notes WHERE id = ?");
    $stmt->execute([$id]);
    
    jsonResponse(['success' => true, 'message' => 'Not silindi']);
}
