<?php
/**
 * Randevu Sistemi V7 - Blok Zamanlar API
 * o2nar.com/test/api/blocked-times.php
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once __DIR__ . '/../includes/config.php';

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            getBlocks();
            break;
        case 'POST':
            createBlock();
            break;
        case 'DELETE':
            deleteBlock();
            break;
        default:
            jsonResponse(['error' => 'Method not allowed'], 405);
    }
} catch (Exception $e) {
    jsonResponse(['error' => $e->getMessage()], 500);
}

function getBlocks() {
    $date = $_GET['date'] ?? date('Y-m-d');
    $staffId = $_GET['staff_id'] ?? null;
    
    $sql = "
        SELECT bt.*, CONCAT(s.first_name, ' ', s.last_name) as staff_name
        FROM blocked_times bt
        LEFT JOIN staff s ON bt.staff_id = s.id
        WHERE bt.block_date = ?
    ";
    
    $params = [$date];
    
    if ($staffId) {
        $sql .= " AND bt.staff_id = ?";
        $params[] = $staffId;
    }
    
    $sql .= " ORDER BY bt.start_time ASC";
    
    $stmt = db()->prepare($sql);
    $stmt->execute($params);
    
    jsonResponse([
        'success' => true,
        'blocks' => $stmt->fetchAll()
    ]);
}

function createBlock() {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (empty($data['staff_id']) || empty($data['block_date']) || empty($data['start_time']) || empty($data['end_time'])) {
        jsonResponse(['error' => 'Eksik bilgi'], 400);
    }
    
    // Çakışma kontrolü - randevu var mı?
    $conflictSql = "
        SELECT id FROM appointments 
        WHERE staff_id = ? AND appointment_date = ? 
        AND status NOT IN ('cancelled')
        AND (
            (start_time < ? AND end_time > ?) OR
            (start_time >= ? AND start_time < ?)
        )
    ";
    $conflictStmt = db()->prepare($conflictSql);
    $conflictStmt->execute([
        $data['staff_id'],
        $data['block_date'],
        $data['end_time'], $data['start_time'],
        $data['start_time'], $data['end_time']
    ]);
    
    if ($conflictStmt->fetch()) {
        jsonResponse(['error' => 'Bu saatte randevu var, önce iptal edin'], 400);
    }
    
    $sql = "
        INSERT INTO blocked_times 
        (staff_id, block_date, start_time, end_time, block_type, reason, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())
    ";
    
    $stmt = db()->prepare($sql);
    $stmt->execute([
        $data['staff_id'],
        $data['block_date'],
        $data['start_time'],
        $data['end_time'],
        $data['block_type'] ?? 'other',
        $data['reason'] ?? null
    ]);
    
    jsonResponse([
        'success' => true,
        'id' => db()->lastInsertId(),
        'message' => 'Blok oluşturuldu'
    ]);
}

function deleteBlock() {
    $id = $_GET['id'] ?? null;
    
    if (!$id) {
        jsonResponse(['error' => 'ID gerekli'], 400);
    }
    
    $stmt = db()->prepare("DELETE FROM blocked_times WHERE id = ?");
    $stmt->execute([$id]);
    
    jsonResponse(['success' => true, 'message' => 'Blok silindi']);
}
