# 🏥 Randevu Sistemi V7 - Kurulum Rehberi

## 📋 Dosya Yapısı

```
/test/
├── admin/
│   ├── index.php        ← Admin Takvim (Ana sayfa)
│   ├── patients.php     ← Hasta Yönetimi
│   ├── login.php        ← Giriş
│   └── logout.php       ← Çıkış
├── api/
│   ├── appointments.php     ← Randevu API
│   ├── patients.php         ← Hasta API
│   ├── patient-notes.php    ← Hasta Notları API
│   ├── patients-import.php  ← İçe Aktarma API
│   └── blocked-times.php    ← Blok Zamanlar API
├── includes/
│   ├── config.php       ← Ayarlar + DB Bağlantısı
│   └── auth.php         ← Kimlik Doğrulama
└── database/
    └── schema.sql       ← Veritabanı Şeması
```

---

## 🚀 Adım Adım Kurulum

### 1️⃣ Dosyaları Sunucuya Yükle

**cPanel File Manager veya FTP ile:**

1. ZIP dosyasını aç
2. Tüm dosyaları `/public_html/test/` klasörüne yükle
3. Klasör yapısının doğru olduğundan emin ol

---

### 2️⃣ Veritabanı Ayarları

**phpMyAdmin'de:**

1. Veritabanını seç (veya yeni oluştur)
2. **SQL** sekmesine git
3. `database/schema.sql` içeriğini yapıştır
4. **Git** butonuna tıkla

---

### 3️⃣ Config Dosyasını Düzenle

**`/test/includes/config.php`** dosyasını aç ve bu satırları düzenle:

```php
// Veritabanı ayarları
define('DB_HOST', 'localhost');
define('DB_NAME', 'VERITABANI_ADINIZ');    // ← Değiştir
define('DB_USER', 'KULLANICI_ADINIZ');      // ← Değiştir
define('DB_PASS', 'SIFRENIZ');              // ← Değiştir
```

---

### 4️⃣ Giriş Bilgileri

**Varsayılan şifre:** `123456`

| E-posta | Rol |
|---------|-----|
| ozgur@o2nar.com | Super Admin |
| gul@o2nar.com | Admin |
| haydar@o2nar.com | Staff |
| nurgul@o2nar.com | Staff |

⚠️ **ÖNEMLİ:** İlk girişten sonra şifreleri değiştirin!

---

### 5️⃣ Test Et

1. Tarayıcıda aç: `https://o2nar.com/test/admin/`
2. E-posta ve şifre ile giriş yap
3. Takvim sayfası açılmalı

---

## ⚙️ Ek Ayarlar

### Çalışma Saatleri Değiştirme

`config.php` içinde:

```php
define('WORKING_HOURS_START', '08:00');
define('WORKING_HOURS_END', '18:00');
define('SLOT_DURATION', 15); // dakika
```

### SMS/WhatsApp Ayarları (Netgsm)

```php
define('NETGSM_USERCODE', 'KULLANICI_KODU');
define('NETGSM_PASSWORD', 'API_SIFRESI');
define('NETGSM_HEADER', 'BASLIK');
```

---

## 🎯 Özellikler

### ✅ Takvim (admin/index.php)
- Günlük takvim görünümü
- Kuşbakışı (tüm personel) veya tekli görünüm
- Drag & Drop ile randevu taşıma
- Resize ile süre değiştirme
- Overlapping randevular
- Zaman bloke etme
- Hızlı randevu ekleme

### ✅ Hasta Yönetimi (admin/patients.php)
- Hasta listesi ve arama
- Etiketler (VIP, Düzenli, Sorunlu vb.)
- Kara liste sistemi
- Bildirim tercihleri (SMS/WhatsApp/E-posta)
- Kategorili notlar (Tıbbi, Ödeme, Şikayet, Alerji)
- Randevu geçmişi
- İletişim geçmişi
- Excel import/export
- Toplu işlemler

---

## ❓ Sorun Giderme

### Veritabanı Bağlantı Hatası
- `config.php` içindeki bilgileri kontrol et
- phpMyAdmin'de kullanıcı yetkilerini kontrol et

### 500 Internal Server Error
- PHP hata loglarını kontrol et
- `error_reporting(E_ALL);` satırını aç

### Giriş Yapılamıyor
- Veritabanında `staff` tablosunu kontrol et
- Şifre hash'i doğru mu kontrol et

### Türkçe Karakter Sorunu
- Veritabanı charset: `utf8mb4`
- Tablo collation: `utf8mb4_unicode_ci`

---

## 📞 Yardım

Kurulumda sorun yaşarsan Claude'a sor!
