<?php
/**
 * Dr. Özgür Oktay Nar - PHP CMS Configuration
 * 
 * Bu dosyayı sunucuya yükledikten sonra kendi bilgilerinizle güncelleyin.
 * Güvenlik için bu dosyayı public_html dışında tutmanız önerilir.
 */

// Error reporting (Production'da kapatın)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');

// Timezone
date_default_timezone_set('Europe/Istanbul');

// Session settings
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 1);

// =====================================================
// DATABASE CONFIGURATION
// =====================================================
define('DB_HOST', 'localhost');
define('DB_NAME', 'onarcom_drnar');           // Hozzt'ta oluşturulacak
define('DB_USER', 'onarcom_drnar');           // Hozzt'ta oluşturulacak
define('DB_PASS', 'CHANGE_THIS_PASSWORD');    // Güçlü şifre kullanın
define('DB_CHARSET', 'utf8mb4');
define('DB_PREFIX', 'drnar_');

// WordPress Migration Database (Güzel Hosting - Sadece migration için)
// Bu bilgiler wp-config.php'den alındı
define('WP_DB_HOST', 'localhost');
define('WP_DB_NAME', 'drozguroktaynar_12dd');
define('WP_DB_USER', 'drozguroktaynar_21ddd');
define('WP_DB_PASS', 'zz4613629zz');
define('WP_TABLE_PREFIX', 'wp_');

// NOT: Migration scripti Güzel Hosting'e REMOTE bağlanacak
// Güzel Hosting MySQL remote access açık olmalı veya
// Alternatif: WordPress DB'yi Hozzt'a dump/import yapabilirsiniz

// =====================================================
// SITE CONFIGURATION
// =====================================================
define('SITE_URL', 'https://test.drozguroktaynar.com');  // Production'da değiştirin
define('SITE_NAME', 'Op. Dr. Özgür Oktay Nar');
define('ADMIN_EMAIL', 'ozguroktaynar@gmail.com');

// Paths
define('ROOT_PATH', dirname(__DIR__));
define('INCLUDES_PATH', __DIR__);
define('THEMES_PATH', ROOT_PATH . '/themes');
define('UPLOADS_PATH', ROOT_PATH . '/uploads');
define('CACHE_PATH', ROOT_PATH . '/cache');
define('BACKUPS_PATH', ROOT_PATH . '/backups');
define('LOGS_PATH', ROOT_PATH . '/logs');

// URLs
define('ASSETS_URL', SITE_URL . '/themes/cliniq/assets');
define('UPLOADS_URL', SITE_URL . '/uploads');

// =====================================================
// SECURITY
// =====================================================
// Secret key for encryption (32 characters random string)
define('SECRET_KEY', 'CHANGE_THIS_TO_RANDOM_32_CHAR_STRING');

// CSRF Token lifetime (seconds)
define('CSRF_TOKEN_LIFETIME', 3600);

// Admin session lifetime (seconds)
define('ADMIN_SESSION_LIFETIME', 7200);

// Max login attempts before lockout
define('MAX_LOGIN_ATTEMPTS', 5);

// Lockout duration (seconds)
define('LOCKOUT_DURATION', 1800);

// Allowed file upload types
define('ALLOWED_FILE_TYPES', [
    'image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/svg+xml',
    'application/pdf',
    'video/mp4', 'video/webm'
]);

// Max upload size (bytes) - 10MB
define('MAX_UPLOAD_SIZE', 10 * 1024 * 1024);

// =====================================================
// API KEYS (Production'da environment variables kullanın)
// =====================================================

// Google APIs
define('GOOGLE_MAPS_API_KEY', '');
define('GOOGLE_PLACES_API_KEY', '');
define('GOOGLE_PLACE_ID', '');  // Google My Business Place ID
define('GA4_MEASUREMENT_ID', '');
define('GTM_CONTAINER_ID', '');

// Facebook
define('FACEBOOK_PIXEL_ID', '549998077208506');
define('FACEBOOK_PIXEL_ID_2', '328042519789419');

// n8n Integration
define('N8N_WEBHOOK_URL', '');  // n8n workflow webhook URL
define('N8N_WEBHOOK_SECRET', '');  // Webhook authentication

// Anthropic (Claude AI)
define('ANTHROPIC_API_KEY', '');

// Netgsm (SMS/WhatsApp)
define('NETGSM_USERCODE', '');
define('NETGSM_PASSWORD', '');
define('NETGSM_MSGHEADER', '');

// =====================================================
// CACHE SETTINGS
// =====================================================
define('CACHE_ENABLED', true);
define('CACHE_TTL', 3600);  // 1 hour
define('PAGE_CACHE_TTL', 86400);  // 24 hours

// =====================================================
// MULTILANGUAGE
// =====================================================
define('DEFAULT_LANG', 'tr');
define('AVAILABLE_LANGS', ['tr', 'en']);
define('LANG_COOKIE_NAME', 'site_lang');

// =====================================================
// FEATURES (Enable/Disable)
// =====================================================
define('FEATURE_NEWSLETTER', false);
define('FEATURE_GOOGLE_REVIEWS', true);
define('FEATURE_BLOG_COMMENTS', false);
define('FEATURE_MULTILANG', true);
define('FEATURE_CACHE', true);
define('FEATURE_SEO_ANALYSIS', true);

// =====================================================
// DEBUG & DEVELOPMENT
// =====================================================
define('DEBUG_MODE', false);  // Production'da false yapın
define('SHOW_SQL_QUERIES', false);
define('LOG_LEVEL', 'error');  // debug, info, warning, error

// =====================================================
// AUTOLOAD & INITIALIZATION
// =====================================================

// Composer autoload (varsa)
if (file_exists(ROOT_PATH . '/vendor/autoload.php')) {
    require_once ROOT_PATH . '/vendor/autoload.php';
}

// Core classes
require_once INCLUDES_PATH . '/Database.php';
require_once INCLUDES_PATH . '/functions.php';

// Initialize database connection
try {
    $db = Database::getInstance();
} catch (Exception $e) {
    if (DEBUG_MODE) {
        die('Database connection failed: ' . $e->getMessage());
    } else {
        die('Site geçici olarak kullanılamıyor. Lütfen daha sonra tekrar deneyin.');
    }
}

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set default language
if (!isset($_SESSION['lang'])) {
    $_SESSION['lang'] = DEFAULT_LANG;
}

// Load settings from database
function loadSettings() {
    global $db;
    static $settings = null;
    
    if ($settings === null) {
        $settings = [];
        try {
            $stmt = $db->query("SELECT setting_key, setting_value FROM settings WHERE autoload = 1");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $settings[$row['setting_key']] = $row['setting_value'];
            }
        } catch (Exception $e) {
            // Settings table might not exist yet (during installation)
        }
    }
    
    return $settings;
}

// Get setting value
function getSetting($key, $default = '') {
    $settings = loadSettings();
    return $settings[$key] ?? $default;
}

// =====================================================
// HELPER CONSTANTS
// =====================================================

// Current URL
define('CURRENT_URL', (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");

// Is AJAX request
define('IS_AJAX', !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');

// Is Admin area
define('IS_ADMIN', strpos($_SERVER['REQUEST_URI'], '/admin') !== false);
