<?php
/**
 * Admin Login
 */

session_start();
require_once __DIR__ . '/../includes/config.php';

$error = '';

// Already logged in?
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: /admin/');
    exit;
}

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Verify CSRF
    if (!isset($_POST['csrf_token']) || !verifyCsrf($_POST['csrf_token'])) {
        $error = 'Güvenlik hatası. Lütfen tekrar deneyin.';
    } else {
        // Get admin user
        $admin = $db->getRow("SELECT * FROM admins WHERE username = ? OR email = ?", [$username, $username]);
        
        if ($admin) {
            // Check if locked
            if ($admin['status'] === 'locked' && $admin['locked_until'] && strtotime($admin['locked_until']) > time()) {
                $error = 'Hesabınız geçici olarak kilitlendi. Lütfen daha sonra tekrar deneyin.';
            }
            // Verify password
            elseif (password_verify($password, $admin['password_hash'])) {
                // Success - create session
                $_SESSION['admin_logged_in'] = true;
                $_SESSION['admin_id'] = $admin['id'];
                $_SESSION['admin_username'] = $admin['username'];
                $_SESSION['admin_role'] = $admin['role'];
                $_SESSION['admin_name'] = $admin['display_name'];
                
                // Update last login
                $db->query("UPDATE admins SET last_login = NOW(), login_attempts = 0 WHERE id = ?", [$admin['id']]);
                
                // Log activity
                $db->insert('activity_log', [
                    'admin_id' => $admin['id'],
                    'action' => 'login',
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                    'user_agent' => $_SERVER['HTTP_USER_AGENT']
                ]);
                
                header('Location: /admin/');
                exit;
            } else {
                // Wrong password
                $attempts = $admin['login_attempts'] + 1;
                
                if ($attempts >= MAX_LOGIN_ATTEMPTS) {
                    $db->query("UPDATE admins SET login_attempts = ?, status = 'locked', locked_until = DATE_ADD(NOW(), INTERVAL ? SECOND) WHERE id = ?", 
                        [$attempts, LOCKOUT_DURATION, $admin['id']]);
                    $error = 'Çok fazla hatalı giriş denemesi. Hesabınız 30 dakika kilitlendi.';
                } else {
                    $db->query("UPDATE admins SET login_attempts = ? WHERE id = ?", [$attempts, $admin['id']]);
                    $error = 'Hatalı şifre.';
                }
            }
        } else {
            $error = 'Kullanıcı bulunamadı.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Giriş Yap - Admin Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #0ea5e9 0%, #1e40af 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            width: 100%;
            max-width: 420px;
            overflow: hidden;
        }
        .login-header {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            padding: 30px;
            text-align: center;
        }
        .login-header img {
            height: 60px;
            margin-bottom: 16px;
        }
        .login-header h1 {
            color: white;
            font-size: 20px;
            font-weight: 600;
        }
        .login-header p {
            color: #94a3b8;
            font-size: 14px;
            margin-top: 4px;
        }
        .login-body {
            padding: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 6px;
            font-weight: 500;
            color: #334155;
            font-size: 14px;
        }
        .form-group input {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 15px;
            transition: all 0.2s;
        }
        .form-group input:focus {
            outline: none;
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }
        .btn {
            width: 100%;
            padding: 14px 24px;
            background: linear-gradient(135deg, #0ea5e9 0%, #1e40af 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(14, 165, 233, 0.3);
        }
        .error {
            background: #fef2f2;
            color: #991b1b;
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            border: 1px solid #fecaca;
        }
        .back-link {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: #64748b;
            text-decoration: none;
            font-size: 14px;
        }
        .back-link:hover {
            color: #0ea5e9;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1>🏥 Admin Panel</h1>
            <p>Op. Dr. Özgür Oktay Nar</p>
        </div>
        
        <div class="login-body">
            <?php if ($error): ?>
                <div class="error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <?= csrfField() ?>
                
                <div class="form-group">
                    <label>Kullanıcı Adı veya E-posta</label>
                    <input type="text" name="username" required autofocus 
                           value="<?= htmlspecialchars($_POST['username'] ?? '') ?>">
                </div>
                
                <div class="form-group">
                    <label>Şifre</label>
                    <input type="password" name="password" required>
                </div>
                
                <button type="submit" class="btn">Giriş Yap</button>
            </form>
            
            <a href="/" class="back-link">← Siteye Dön</a>
        </div>
    </div>
</body>
</html>
