<?php
/**
 * 404 Not Found Template
 */

$lang = CURRENT_LANG;
View::set('pageTitle', $lang === 'tr' ? '404 - Sayfa Bulunamadı' : '404 - Page Not Found');

View::partial('header');
?>

<section class="error-page">
    <div class="container">
        <div class="error-content">
            <h1>404</h1>
            <h2><?= $lang === 'tr' ? 'Sayfa Bulunamadı' : 'Page Not Found' ?></h2>
            <p>
                <?= $lang === 'tr' 
                    ? 'Aradığınız sayfa mevcut değil veya taşınmış olabilir.'
                    : 'The page you are looking for does not exist or may have been moved.'
                ?>
            </p>
            <div class="error-actions">
                <a href="<?= langUrl('/') ?>" class="btn btn-primary">
                    <?= $lang === 'tr' ? 'Ana Sayfaya Dön' : 'Back to Home' ?>
                </a>
                <a href="<?= langUrl('iletisim') ?>" class="btn btn-outline">
                    <?= $lang === 'tr' ? 'İletişim' : 'Contact' ?>
                </a>
            </div>
        </div>
    </div>
</section>

<style>
.error-page {
    min-height: calc(100vh - 80px);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 80px 20px;
    background: var(--bg-light);
}

.error-content {
    text-align: center;
    max-width: 500px;
}

.error-content h1 {
    font-size: 8rem;
    font-weight: 700;
    color: var(--primary);
    line-height: 1;
    margin-bottom: 16px;
}

.error-content h2 {
    font-size: 1.5rem;
    margin-bottom: 16px;
}

.error-content p {
    color: var(--text-secondary);
    margin-bottom: 32px;
}

.error-actions {
    display: flex;
    gap: 16px;
    justify-content: center;
    flex-wrap: wrap;
}

@media (max-width: 480px) {
    .error-content h1 {
        font-size: 5rem;
    }
    
    .error-actions {
        flex-direction: column;
    }
    
    .error-actions .btn {
        width: 100%;
    }
}
</style>

<?php View::partial('footer'); ?>
