-- =====================================================
-- DR. ÖZGÜR OKTAY NAR - PHP CMS DATABASE SCHEMA
-- Cliniq Theme Clone - Full Database Structure
-- =====================================================

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- -----------------------------------------------------
-- Table: settings (Site ayarları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `setting_key` VARCHAR(100) NOT NULL,
    `setting_value` LONGTEXT,
    `setting_group` VARCHAR(50) DEFAULT 'general',
    `autoload` TINYINT(1) DEFAULT 1,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_setting_key` (`setting_key`),
    KEY `idx_group` (`setting_group`),
    KEY `idx_autoload` (`autoload`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: admins (Yönetici kullanıcıları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `admins`;
CREATE TABLE `admins` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `username` VARCHAR(100) NOT NULL,
    `email` VARCHAR(200) NOT NULL,
    `password_hash` VARCHAR(255) NOT NULL,
    `display_name` VARCHAR(200),
    `role` ENUM('super_admin', 'admin', 'editor') DEFAULT 'editor',
    `avatar` VARCHAR(500),
    `last_login` DATETIME,
    `login_attempts` INT DEFAULT 0,
    `locked_until` DATETIME,
    `status` ENUM('active', 'inactive', 'locked') DEFAULT 'active',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_username` (`username`),
    UNIQUE KEY `uk_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: categories (Kategoriler)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `old_wp_id` INT UNSIGNED DEFAULT NULL COMMENT 'WordPress term_id for migration',
    `slug` VARCHAR(100) NOT NULL,
    `name_tr` VARCHAR(200) NOT NULL,
    `name_en` VARCHAR(200),
    `description_tr` TEXT,
    `description_en` TEXT,
    `parent_id` INT UNSIGNED DEFAULT NULL,
    `sort_order` INT DEFAULT 0,
    `post_count` INT DEFAULT 0,
    `meta_title_tr` VARCHAR(255),
    `meta_title_en` VARCHAR(255),
    `meta_description_tr` TEXT,
    `meta_description_en` TEXT,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_slug` (`slug`),
    KEY `idx_parent` (`parent_id`),
    KEY `idx_old_wp_id` (`old_wp_id`),
    KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: pages (Sayfalar - Hakkımda, İletişim vb.)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pages`;
CREATE TABLE `pages` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `old_wp_id` INT UNSIGNED DEFAULT NULL COMMENT 'WordPress post_id for migration',
    `slug` VARCHAR(255) NOT NULL,
    `title_tr` VARCHAR(500) NOT NULL,
    `title_en` VARCHAR(500),
    `content_tr` LONGTEXT,
    `content_en` LONGTEXT,
    `excerpt_tr` TEXT,
    `excerpt_en` TEXT,
    `meta_title_tr` VARCHAR(255),
    `meta_title_en` VARCHAR(255),
    `meta_description_tr` TEXT,
    `meta_description_en` TEXT,
    `meta_keywords_tr` VARCHAR(500),
    `meta_keywords_en` VARCHAR(500),
    `og_image` VARCHAR(500),
    `featured_image` VARCHAR(500),
    `template` VARCHAR(100) DEFAULT 'default',
    `parent_id` INT UNSIGNED DEFAULT NULL,
    `sort_order` INT DEFAULT 0,
    `show_in_menu` TINYINT(1) DEFAULT 1,
    `status` ENUM('published', 'draft', 'trash') DEFAULT 'draft',
    `author_id` INT UNSIGNED,
    `views` INT UNSIGNED DEFAULT 0,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `published_at` DATETIME,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_slug` (`slug`),
    KEY `idx_old_wp_id` (`old_wp_id`),
    KEY `idx_status` (`status`),
    KEY `idx_template` (`template`),
    KEY `idx_parent` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: posts (Blog yazıları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `posts`;
CREATE TABLE `posts` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `old_wp_id` INT UNSIGNED DEFAULT NULL COMMENT 'WordPress post_id for migration',
    `slug` VARCHAR(255) NOT NULL,
    `title_tr` VARCHAR(500) NOT NULL,
    `title_en` VARCHAR(500),
    `content_tr` LONGTEXT,
    `content_en` LONGTEXT,
    `excerpt_tr` TEXT,
    `excerpt_en` TEXT,
    `meta_title_tr` VARCHAR(255),
    `meta_title_en` VARCHAR(255),
    `meta_description_tr` TEXT,
    `meta_description_en` TEXT,
    `meta_keywords_tr` VARCHAR(500),
    `meta_keywords_en` VARCHAR(500),
    `og_image` VARCHAR(500),
    `featured_image` VARCHAR(500),
    `featured_image_alt_tr` VARCHAR(255),
    `featured_image_alt_en` VARCHAR(255),
    `category_id` INT UNSIGNED,
    `author_id` INT UNSIGNED,
    `author_name` VARCHAR(200) DEFAULT 'Op. Dr. Özgür Oktay Nar',
    `reading_time` INT DEFAULT 0 COMMENT 'Minutes',
    `status` ENUM('published', 'draft', 'pending', 'trash') DEFAULT 'draft',
    `is_featured` TINYINT(1) DEFAULT 0,
    `allow_comments` TINYINT(1) DEFAULT 0,
    `views` INT UNSIGNED DEFAULT 0,
    -- n8n / AI entegrasyonu
    `ai_generated` TINYINT(1) DEFAULT 0,
    `human_reviewed` TINYINT(1) DEFAULT 0,
    `ai_model` VARCHAR(50),
    `source_keyword` VARCHAR(255) COMMENT 'Google Trends keyword',
    -- Schema.org
    `schema_type` VARCHAR(50) DEFAULT 'Article',
    -- Timestamps
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `published_at` DATETIME,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_slug` (`slug`),
    KEY `idx_old_wp_id` (`old_wp_id`),
    KEY `idx_category` (`category_id`),
    KEY `idx_status` (`status`),
    KEY `idx_featured` (`is_featured`),
    KEY `idx_published` (`published_at`),
    KEY `idx_ai_generated` (`ai_generated`),
    FULLTEXT KEY `ft_search_tr` (`title_tr`, `content_tr`),
    FULLTEXT KEY `ft_search_en` (`title_en`, `content_en`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: post_tags (Etiketler - Many-to-Many)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `old_wp_id` INT UNSIGNED DEFAULT NULL,
    `slug` VARCHAR(100) NOT NULL,
    `name_tr` VARCHAR(200) NOT NULL,
    `name_en` VARCHAR(200),
    `post_count` INT DEFAULT 0,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_slug` (`slug`),
    KEY `idx_old_wp_id` (`old_wp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `post_tags`;
CREATE TABLE `post_tags` (
    `post_id` INT UNSIGNED NOT NULL,
    `tag_id` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`post_id`, `tag_id`),
    KEY `idx_tag` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: services (Uzmanlık Alanları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `services`;
CREATE TABLE `services` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `old_wp_id` INT UNSIGNED DEFAULT NULL,
    `slug` VARCHAR(255) NOT NULL,
    `title_tr` VARCHAR(300) NOT NULL,
    `title_en` VARCHAR(300),
    `subtitle_tr` VARCHAR(500),
    `subtitle_en` VARCHAR(500),
    `content_tr` LONGTEXT,
    `content_en` LONGTEXT,
    `excerpt_tr` TEXT,
    `excerpt_en` TEXT,
    `icon` VARCHAR(100) COMMENT 'Icon class or SVG filename',
    `icon_image` VARCHAR(500),
    `featured_image` VARCHAR(500),
    `gallery` JSON COMMENT 'Array of image paths',
    `meta_title_tr` VARCHAR(255),
    `meta_title_en` VARCHAR(255),
    `meta_description_tr` TEXT,
    `meta_description_en` TEXT,
    `parent_id` INT UNSIGNED DEFAULT NULL,
    `sort_order` INT DEFAULT 0,
    `show_on_home` TINYINT(1) DEFAULT 1,
    `status` ENUM('published', 'draft') DEFAULT 'published',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_slug` (`slug`),
    KEY `idx_old_wp_id` (`old_wp_id`),
    KEY `idx_parent` (`parent_id`),
    KEY `idx_sort` (`sort_order`),
    KEY `idx_home` (`show_on_home`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: media (Medya kütüphanesi)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `media`;
CREATE TABLE `media` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `old_wp_id` INT UNSIGNED DEFAULT NULL,
    `filename` VARCHAR(255) NOT NULL,
    `original_filename` VARCHAR(255),
    `filepath` VARCHAR(500) NOT NULL,
    `url` VARCHAR(500),
    `alt_text_tr` VARCHAR(255),
    `alt_text_en` VARCHAR(255),
    `title_tr` VARCHAR(255),
    `title_en` VARCHAR(255),
    `caption_tr` TEXT,
    `caption_en` TEXT,
    `mime_type` VARCHAR(100),
    `file_size` INT UNSIGNED COMMENT 'Bytes',
    `width` INT UNSIGNED,
    `height` INT UNSIGNED,
    `thumbnails` JSON COMMENT 'Generated thumbnail paths',
    `folder` VARCHAR(100) DEFAULT 'uploads',
    `uploaded_by` INT UNSIGNED,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_old_wp_id` (`old_wp_id`),
    KEY `idx_mime` (`mime_type`),
    KEY `idx_folder` (`folder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: videos (YouTube videoları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `videos`;
CREATE TABLE `videos` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `youtube_id` VARCHAR(50) NOT NULL,
    `title_tr` VARCHAR(255),
    `title_en` VARCHAR(255),
    `description_tr` TEXT,
    `description_en` TEXT,
    `thumbnail` VARCHAR(500),
    `thumbnail_hq` VARCHAR(500),
    `duration` VARCHAR(20),
    `duration_seconds` INT,
    `category` VARCHAR(100),
    `sort_order` INT DEFAULT 0,
    `show_on_home` TINYINT(1) DEFAULT 1,
    `views` INT DEFAULT 0,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_youtube_id` (`youtube_id`),
    KEY `idx_sort` (`sort_order`),
    KEY `idx_home` (`show_on_home`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: reviews (Google Yorumları cache)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `reviews`;
CREATE TABLE `reviews` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `external_id` VARCHAR(100) COMMENT 'Google review ID',
    `author_name` VARCHAR(200),
    `author_photo` VARCHAR(500),
    `rating` TINYINT UNSIGNED,
    `text` TEXT,
    `text_tr` TEXT COMMENT 'Translated version',
    `language` VARCHAR(10),
    `review_time` DATETIME,
    `relative_time` VARCHAR(100),
    `source` ENUM('google', 'manual', 'trustindex') DEFAULT 'google',
    `is_featured` TINYINT(1) DEFAULT 0,
    `show_on_site` TINYINT(1) DEFAULT 1,
    `cached_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_external_id` (`external_id`),
    KEY `idx_rating` (`rating`),
    KEY `idx_featured` (`is_featured`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: menus (Menü yapısı)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `menus`;
CREATE TABLE `menus` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `location` VARCHAR(50) NOT NULL COMMENT 'header, footer, mobile',
    `title_tr` VARCHAR(200),
    `title_en` VARCHAR(200),
    `url` VARCHAR(500),
    `target` ENUM('_self', '_blank') DEFAULT '_self',
    `icon` VARCHAR(100),
    `parent_id` INT UNSIGNED DEFAULT NULL,
    `sort_order` INT DEFAULT 0,
    `css_class` VARCHAR(100),
    `is_mega_menu` TINYINT(1) DEFAULT 0,
    `mega_menu_content` JSON,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_location` (`location`),
    KEY `idx_parent` (`parent_id`),
    KEY `idx_sort` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: faqs (Sıkça Sorulan Sorular)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `faqs`;
CREATE TABLE `faqs` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `question_tr` VARCHAR(500) NOT NULL,
    `question_en` VARCHAR(500),
    `answer_tr` TEXT NOT NULL,
    `answer_en` TEXT,
    `category` VARCHAR(100),
    `sort_order` INT DEFAULT 0,
    `show_on_home` TINYINT(1) DEFAULT 0,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_category` (`category`),
    KEY `idx_home` (`show_on_home`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: redirects (SEO 301 yönlendirmeleri)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `redirects`;
CREATE TABLE `redirects` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `old_url` VARCHAR(500) NOT NULL,
    `new_url` VARCHAR(500) NOT NULL,
    `redirect_type` ENUM('301', '302', '307') DEFAULT '301',
    `hit_count` INT DEFAULT 0,
    `last_hit` DATETIME,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_old_url` (`old_url`(255)),
    KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: newsletter_subscribers
-- -----------------------------------------------------
DROP TABLE IF EXISTS `newsletter_subscribers`;
CREATE TABLE `newsletter_subscribers` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `email` VARCHAR(200) NOT NULL,
    `name` VARCHAR(200),
    `status` ENUM('active', 'unsubscribed', 'bounced') DEFAULT 'active',
    `source` VARCHAR(100) DEFAULT 'website',
    `ip_address` VARCHAR(45),
    `subscribed_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `unsubscribed_at` DATETIME,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_email` (`email`),
    KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: contact_submissions (İletişim formu kayıtları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `contact_submissions`;
CREATE TABLE `contact_submissions` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(200),
    `email` VARCHAR(200),
    `phone` VARCHAR(50),
    `subject` VARCHAR(300),
    `message` TEXT,
    `ip_address` VARCHAR(45),
    `user_agent` TEXT,
    `is_read` TINYINT(1) DEFAULT 0,
    `is_spam` TINYINT(1) DEFAULT 0,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_read` (`is_read`),
    KEY `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: analytics_cache (Google Analytics cache)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `analytics_cache`;
CREATE TABLE `analytics_cache` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `metric_type` VARCHAR(50) NOT NULL,
    `metric_key` VARCHAR(100),
    `metric_value` JSON,
    `date_range` VARCHAR(50),
    `start_date` DATE,
    `end_date` DATE,
    `cached_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `expires_at` DATETIME,
    PRIMARY KEY (`id`),
    KEY `idx_type` (`metric_type`),
    KEY `idx_expires` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: seo_analysis (SEO analiz sonuçları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `seo_analysis`;
CREATE TABLE `seo_analysis` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `entity_type` ENUM('page', 'post', 'service') NOT NULL,
    `entity_id` INT UNSIGNED NOT NULL,
    `url` VARCHAR(500),
    `score` INT DEFAULT 0,
    `issues` JSON,
    `suggestions` JSON,
    `lighthouse_score` INT,
    `last_analyzed` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_entity` (`entity_type`, `entity_id`),
    KEY `idx_score` (`score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: backups (Yedekleme logları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `backups`;
CREATE TABLE `backups` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `filename` VARCHAR(255) NOT NULL,
    `filepath` VARCHAR(500),
    `file_size` BIGINT UNSIGNED,
    `backup_type` ENUM('full', 'database', 'files', 'auto') DEFAULT 'full',
    `status` ENUM('completed', 'failed', 'in_progress') DEFAULT 'completed',
    `notes` TEXT,
    `created_by` INT UNSIGNED,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_type` (`backup_type`),
    KEY `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: activity_log (Admin aktivite logları)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE `activity_log` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `admin_id` INT UNSIGNED,
    `action` VARCHAR(100) NOT NULL,
    `entity_type` VARCHAR(50),
    `entity_id` INT UNSIGNED,
    `old_values` JSON,
    `new_values` JSON,
    `ip_address` VARCHAR(45),
    `user_agent` TEXT,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_admin` (`admin_id`),
    KEY `idx_action` (`action`),
    KEY `idx_entity` (`entity_type`, `entity_id`),
    KEY `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: n8n_content_queue (n8n ile üretilen içerikler)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `n8n_content_queue`;
CREATE TABLE `n8n_content_queue` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `workflow_id` VARCHAR(100),
    `execution_id` VARCHAR(100),
    `content_type` ENUM('post', 'page', 'social') DEFAULT 'post',
    `source_keyword` VARCHAR(255),
    `generated_title` VARCHAR(500),
    `generated_content` LONGTEXT,
    `generated_meta` JSON,
    `ai_model` VARCHAR(50) DEFAULT 'claude-3-sonnet',
    `status` ENUM('pending', 'approved', 'rejected', 'published') DEFAULT 'pending',
    `reviewed_by` INT UNSIGNED,
    `reviewed_at` DATETIME,
    `published_as_id` INT UNSIGNED COMMENT 'Reference to posts.id after publishing',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_status` (`status`),
    KEY `idx_workflow` (`workflow_id`),
    KEY `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -----------------------------------------------------
-- Table: cron_jobs (Zamanlanmış görevler)
-- -----------------------------------------------------
DROP TABLE IF EXISTS `cron_jobs`;
CREATE TABLE `cron_jobs` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `job_name` VARCHAR(100) NOT NULL,
    `job_handler` VARCHAR(255) NOT NULL,
    `schedule` VARCHAR(50) COMMENT 'Cron expression',
    `last_run` DATETIME,
    `next_run` DATETIME,
    `status` ENUM('active', 'inactive', 'running') DEFAULT 'active',
    `last_result` ENUM('success', 'failed'),
    `last_message` TEXT,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_job_name` (`job_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- DEFAULT DATA INSERTS
-- =====================================================

-- Default admin user (password: admin123 - değiştir!)
INSERT INTO `admins` (`username`, `email`, `password_hash`, `display_name`, `role`) VALUES
('admin', 'ozguroktaynar@gmail.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Op. Dr. Özgür Oktay Nar', 'super_admin');

-- Default settings
INSERT INTO `settings` (`setting_key`, `setting_value`, `setting_group`) VALUES
-- Genel
('site_name_tr', 'Op. Dr. Özgür Oktay Nar', 'general'),
('site_name_en', 'Op. Dr. Özgür Oktay Nar', 'general'),
('site_tagline_tr', 'Ortopedi ve Travmatoloji Uzmanı', 'general'),
('site_tagline_en', 'Orthopedics and Traumatology Specialist', 'general'),
('site_description_tr', 'Bursa''da ortopedi ve travmatoloji alanında uzman hekim. PRP, kök hücre tedavisi, proloterapi ve minimal invaziv cerrahi.', 'general'),
('site_email', 'ozguroktaynar@gmail.com', 'general'),
('site_phone', '+90 539 841 68 01', 'general'),
('site_whatsapp', '+90 552 249 39 09', 'general'),
('site_address_tr', 'Bağlarbaşı Mah. Sanayi Cad. 348/B No:46 (Opus Evke Plaza) Osmangazi / BURSA', 'general'),
('site_address_en', 'Bağlarbaşı Mah. Sanayi Cad. 348/B No:46 (Opus Evke Plaza) Osmangazi / BURSA', 'general'),
('default_language', 'tr', 'general'),
('timezone', 'Europe/Istanbul', 'general'),
('date_format', 'd.m.Y', 'general'),
('time_format', 'H:i', 'general'),

-- Social Media
('social_instagram', 'https://www.instagram.com/ozguroktaynar/', 'social'),
('social_facebook', 'https://www.facebook.com/op.dr.ozguroktaynar/', 'social'),
('social_youtube', 'https://www.youtube.com/channel/UClaPRAwb54Lxnd99tQ2xf1A', 'social'),
('social_twitter', '', 'social'),
('social_linkedin', '', 'social'),

-- SEO
('meta_title_separator', ' | ', 'seo'),
('default_og_image', '/uploads/og-default.jpg', 'seo'),
('google_site_verification', '', 'seo'),
('bing_site_verification', '', 'seo'),
('robots_txt', 'User-agent: *\nAllow: /\nSitemap: https://drozguroktaynar.com/sitemap.xml', 'seo'),

-- Analytics
('ga_tracking_id', '', 'analytics'),
('ga4_measurement_id', '', 'analytics'),
('gtm_container_id', '', 'analytics'),
('facebook_pixel_id', '549998077208506', 'analytics'),
('facebook_pixel_id_2', '328042519789419', 'analytics'),

-- API Keys
('google_maps_api_key', '', 'api'),
('google_places_api_key', '', 'api'),
('google_place_id', '', 'api'),
('n8n_webhook_secret', '', 'api'),
('anthropic_api_key', '', 'api'),

-- Features (on/off switches)
('feature_newsletter', '0', 'features'),
('feature_google_reviews', '1', 'features'),
('feature_blog_comments', '0', 'features'),
('feature_multilang', '1', 'features'),

-- Cache
('cache_enabled', '1', 'cache'),
('cache_ttl', '3600', 'cache'),

-- Appearance
('logo_light', '/themes/cliniq/assets/images/logo.webp', 'appearance'),
('logo_dark', '/themes/cliniq/assets/images/logo-dark.webp', 'appearance'),
('favicon', '/themes/cliniq/assets/images/favicon.ico', 'appearance'),
('primary_color', '#0ea5e9', 'appearance'),
('secondary_color', '#1e40af', 'appearance'),

-- Working Hours
('working_hours', '{"monday":"10:00 - 17:00","tuesday":"10:00 - 17:00","wednesday":"10:00 - 17:00","thursday":"10:00 - 17:00","friday":"10:00 - 17:00","saturday":"10:00 - 14:00","sunday":"Kapalı"}', 'contact'),

-- Appointment
('appointment_url', 'https://www.doktortakvimi.com/ozgur-oktay-nar/ortopedi-ve-travmatoloji/bursa', 'appointment');

-- Default categories
INSERT INTO `categories` (`slug`, `name_tr`, `name_en`, `sort_order`) VALUES
('ortopedi', 'Ortopedi', 'Orthopedics', 1),
('fizik-tedavi', 'Fizik Tedavi', 'Physical Therapy', 2),
('sporcu-sagligi', 'Sporcu Sağlığı', 'Sports Medicine', 3),
('genel-saglik', 'Genel Sağlık', 'General Health', 4);

-- Default FAQs
INSERT INTO `faqs` (`question_tr`, `question_en`, `answer_tr`, `answer_en`, `sort_order`, `show_on_home`) VALUES
('Ortopedik sorunlar hangi belirtilerle kendini gösterir?', 'What symptoms indicate orthopedic problems?', 'Ortopedik sorunlar genellikle ağrı, şişlik, hareket kısıtlılığı, deformiteler ve zayıflık gibi belirtilerle kendini gösterir.\n\n**Detaylı Bilgi için [Bize Ulaşın](https://wa.me/905522493909)**', 'Orthopedic problems usually manifest with symptoms such as pain, swelling, limited mobility, deformities, and weakness.', 1, 1),
('Ortopedik tedavi yöntemleri nelerdir?', 'What are orthopedic treatment methods?', 'Ortopedik tedavi yöntemleri arasında fizik tedavi, cerrahi müdahale, medikal tedavi, rehabilitasyon ve destekleyici cihazlar kullanımı bulunmaktadır.\n\n**Detaylı Bilgi için [Bize Ulaşın](https://wa.me/905522493909)**', 'Orthopedic treatment methods include physical therapy, surgical intervention, medical treatment, rehabilitation, and use of supportive devices.', 2, 1),
('Ameliyat sonrası iyileşme süreci ne kadar sürer?', 'How long is the post-operative recovery period?', 'Ameliyat sonrası iyileşme süreci, yapılan müdahaleye, hastanın genel sağlık durumuna ve rehabilitasyon sürecine bağlı olarak değişiklik gösterebilir.\n\n**Detaylı Bilgi için [Bize Ulaşın](https://wa.me/905522493909)**', 'The post-operative recovery period may vary depending on the procedure performed, the patient''s general health condition, and the rehabilitation process.', 3, 1),
('Ortopedik sorunların önlenmesi için neler yapılabilir?', 'What can be done to prevent orthopedic problems?', 'Ortopedik sorunların önlenmesi için düzenli egzersiz, sağlıklı beslenme, uygun ayakkabı seçimi ve iyi duruş alışkanlıkları geliştirmek önemlidir.\n\n**Detaylı Bilgi için [Bize Ulaşın](https://wa.me/905522493909)**', 'To prevent orthopedic problems, it is important to exercise regularly, eat healthy, choose appropriate footwear, and develop good posture habits.', 4, 1),
('Hangi yaş grubundaki kişiler ortopedik sorunlarla karşılaşabilir?', 'What age group can experience orthopedic problems?', 'Ortopedik sorunlar her yaş grubundaki bireylerde görülebilir. Özellikle yaşlılar, sporcular ve obezite gibi risk faktörleri taşıyan kişiler daha fazla risk altındadır.\n\n**Detaylı Bilgi için [Bize Ulaşın](https://wa.me/905522493909)**', 'Orthopedic problems can occur in individuals of all age groups. Especially the elderly, athletes, and people with risk factors such as obesity are at higher risk.', 5, 1),
('Spor yaralanmalarında ne yapılmalı?', 'What should be done for sports injuries?', 'Spor yaralanmalarında ilk olarak dinlenme, buz uygulaması ve yükseltme gibi ilk yardım önlemleri alınmalı, ardından ortopedi uzmanına başvurulmalıdır.\n\n**Detaylı Bilgi için [Bize Ulaşın](https://wa.me/905522493909)**', 'For sports injuries, first aid measures such as rest, ice application, and elevation should be taken first, then an orthopedic specialist should be consulted.', 6, 1);

SET FOREIGN_KEY_CHECKS = 1;
