<?php
/**
 * Admin Panel - Settings
 */

require_once __DIR__ . '/../includes/config.php';

// Check authentication
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: /admin/login.php');
    exit;
}

$message = '';

// Handle save
if ($_SERVER['REQUEST_METHOD'] === 'POST' && verifyCsrf($_POST['csrf_token'] ?? '')) {
    $settings = [
        'site_name' => $_POST['site_name'] ?? '',
        'site_tagline' => $_POST['site_tagline'] ?? '',
        'site_description' => $_POST['site_description'] ?? '',
        'contact_email' => $_POST['contact_email'] ?? '',
        'contact_phone' => $_POST['contact_phone'] ?? '',
        'contact_address' => $_POST['contact_address'] ?? '',
        'social_instagram' => $_POST['social_instagram'] ?? '',
        'social_facebook' => $_POST['social_facebook'] ?? '',
        'social_youtube' => $_POST['social_youtube'] ?? '',
        'social_twitter' => $_POST['social_twitter'] ?? '',
        'social_linkedin' => $_POST['social_linkedin'] ?? '',
        'whatsapp_number' => $_POST['whatsapp_number'] ?? '',
        'google_maps_embed' => $_POST['google_maps_embed'] ?? '',
        'analytics_id' => $_POST['analytics_id'] ?? '',
        'facebook_pixel' => $_POST['facebook_pixel'] ?? '',
        'header_scripts' => $_POST['header_scripts'] ?? '',
        'footer_scripts' => $_POST['footer_scripts'] ?? '',
    ];
    
    foreach ($settings as $key => $value) {
        $exists = $db->getValue("SELECT COUNT(*) FROM settings WHERE setting_key = ?", [$key]);
        if ($exists) {
            $db->query("UPDATE settings SET setting_value = ? WHERE setting_key = ?", [$value, $key]);
        } else {
            $db->insert('settings', [
                'setting_key' => $key,
                'setting_value' => $value,
                'autoload' => 1
            ]);
        }
    }
    
    $message = 'Ayarlar kaydedildi.';
}

// Load settings
$settingsData = [];
$rows = $db->getAll("SELECT setting_key, setting_value FROM settings");
foreach ($rows as $row) {
    $settingsData[$row['setting_key']] = $row['setting_value'];
}

include __DIR__ . '/includes/header.php';
?>

<div class="content-header">
    <h1>⚙️ Ayarlar</h1>
</div>

<?php if ($message): ?>
    <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<form method="POST">
    <?= csrfField() ?>
    
    <div class="settings-grid">
        <!-- General -->
        <div class="card">
            <div class="card-header"><h3>Genel Ayarlar</h3></div>
            <div class="card-body">
                <div class="form-group">
                    <label>Site Adı</label>
                    <input type="text" name="site_name" value="<?= htmlspecialchars($settingsData['site_name'] ?? 'Op. Dr. Özgür Oktay Nar') ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label>Slogan</label>
                    <input type="text" name="site_tagline" value="<?= htmlspecialchars($settingsData['site_tagline'] ?? '') ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label>Site Açıklaması</label>
                    <textarea name="site_description" rows="3" class="form-control"><?= htmlspecialchars($settingsData['site_description'] ?? '') ?></textarea>
                </div>
            </div>
        </div>
        
        <!-- Contact -->
        <div class="card">
            <div class="card-header"><h3>İletişim Bilgileri</h3></div>
            <div class="card-body">
                <div class="form-group">
                    <label>E-posta</label>
                    <input type="email" name="contact_email" value="<?= htmlspecialchars($settingsData['contact_email'] ?? '') ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label>Telefon</label>
                    <input type="text" name="contact_phone" value="<?= htmlspecialchars($settingsData['contact_phone'] ?? '') ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label>WhatsApp Numarası</label>
                    <input type="text" name="whatsapp_number" value="<?= htmlspecialchars($settingsData['whatsapp_number'] ?? '') ?>" class="form-control" placeholder="905xxxxxxxxx">
                </div>
                <div class="form-group">
                    <label>Adres</label>
                    <textarea name="contact_address" rows="3" class="form-control"><?= htmlspecialchars($settingsData['contact_address'] ?? '') ?></textarea>
                </div>
                <div class="form-group">
                    <label>Google Maps Embed Kodu</label>
                    <textarea name="google_maps_embed" rows="3" class="form-control"><?= htmlspecialchars($settingsData['google_maps_embed'] ?? '') ?></textarea>
                </div>
            </div>
        </div>
        
        <!-- Social -->
        <div class="card">
            <div class="card-header"><h3>Sosyal Medya</h3></div>
            <div class="card-body">
                <div class="form-group">
                    <label>Instagram</label>
                    <input type="url" name="social_instagram" value="<?= htmlspecialchars($settingsData['social_instagram'] ?? '') ?>" class="form-control" placeholder="https://instagram.com/...">
                </div>
                <div class="form-group">
                    <label>Facebook</label>
                    <input type="url" name="social_facebook" value="<?= htmlspecialchars($settingsData['social_facebook'] ?? '') ?>" class="form-control" placeholder="https://facebook.com/...">
                </div>
                <div class="form-group">
                    <label>YouTube</label>
                    <input type="url" name="social_youtube" value="<?= htmlspecialchars($settingsData['social_youtube'] ?? '') ?>" class="form-control" placeholder="https://youtube.com/...">
                </div>
                <div class="form-group">
                    <label>Twitter</label>
                    <input type="url" name="social_twitter" value="<?= htmlspecialchars($settingsData['social_twitter'] ?? '') ?>" class="form-control" placeholder="https://twitter.com/...">
                </div>
                <div class="form-group">
                    <label>LinkedIn</label>
                    <input type="url" name="social_linkedin" value="<?= htmlspecialchars($settingsData['social_linkedin'] ?? '') ?>" class="form-control" placeholder="https://linkedin.com/...">
                </div>
            </div>
        </div>
        
        <!-- Analytics -->
        <div class="card">
            <div class="card-header"><h3>Analitik & İzleme</h3></div>
            <div class="card-body">
                <div class="form-group">
                    <label>Google Analytics ID</label>
                    <input type="text" name="analytics_id" value="<?= htmlspecialchars($settingsData['analytics_id'] ?? '') ?>" class="form-control" placeholder="G-XXXXXXXXXX">
                </div>
                <div class="form-group">
                    <label>Facebook Pixel ID</label>
                    <input type="text" name="facebook_pixel" value="<?= htmlspecialchars($settingsData['facebook_pixel'] ?? '') ?>" class="form-control" placeholder="XXXXXXXXXXXXXXX">
                </div>
                <div class="form-group">
                    <label>Header Scripts (head içine)</label>
                    <textarea name="header_scripts" rows="4" class="form-control" placeholder="<script>...</script>"><?= htmlspecialchars($settingsData['header_scripts'] ?? '') ?></textarea>
                </div>
                <div class="form-group">
                    <label>Footer Scripts (body sonuna)</label>
                    <textarea name="footer_scripts" rows="4" class="form-control" placeholder="<script>...</script>"><?= htmlspecialchars($settingsData['footer_scripts'] ?? '') ?></textarea>
                </div>
            </div>
        </div>
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-primary btn-lg">Ayarları Kaydet</button>
    </div>
</form>

<style>
.settings-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 24px;
    margin-bottom: 24px;
}
.card-header { padding: 16px; border-bottom: 1px solid #e2e8f0; }
.card-header h3 { margin: 0; font-size: 16px; }
.card-body { padding: 16px; }
.form-group { margin-bottom: 16px; }
.form-group label { display: block; margin-bottom: 6px; font-weight: 500; }
.form-actions { text-align: right; padding: 20px 0; }
.btn-lg { padding: 14px 32px; font-size: 16px; }

@media (max-width: 900px) {
    .settings-grid { grid-template-columns: 1fr; }
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
