<?php
/**
 * Admin Panel - Pages Management
 */

require_once __DIR__ . '/../includes/config.php';

// Check authentication
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: /admin/login.php');
    exit;
}

// Pagination
$page = max(1, intval($_GET['page'] ?? 1));
$perPage = 20;
$offset = ($page - 1) * $perPage;

// Filters
$status = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';

// Build query
$where = [];
$params = [];

if ($status) {
    $where[] = "status = ?";
    $params[] = $status;
}

if ($search) {
    $where[] = "(title_tr LIKE ? OR title_en LIKE ?)";
    $params[] = "%{$search}%";
    $params[] = "%{$search}%";
}

$whereClause = $where ? "WHERE " . implode(" AND ", $where) : "";

// Get total count
$total = $db->getValue("SELECT COUNT(*) FROM pages {$whereClause}", $params);
$totalPages = ceil($total / $perPage);

// Get pages
$sql = "SELECT * FROM pages {$whereClause} ORDER BY sort_order ASC, created_at DESC LIMIT {$perPage} OFFSET {$offset}";
$pages = $db->getAll($sql, $params);

// Handle delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_id'])) {
    if (verifyCsrf($_POST['csrf_token'] ?? '')) {
        $db->query("DELETE FROM pages WHERE id = ?", [$_POST['delete_id']]);
        header('Location: /admin/pages.php?deleted=1');
        exit;
    }
}

include __DIR__ . '/includes/header.php';
?>

<div class="content-header">
    <h1>📄 Sayfalar</h1>
    <a href="/admin/page-edit.php" class="btn btn-primary">+ Yeni Sayfa</a>
</div>

<?php if (isset($_GET['deleted'])): ?>
    <div class="alert alert-success">Sayfa başarıyla silindi.</div>
<?php endif; ?>

<?php if (isset($_GET['saved'])): ?>
    <div class="alert alert-success">Sayfa başarıyla kaydedildi.</div>
<?php endif; ?>

<!-- Filters -->
<div class="card mb-4">
    <form method="GET" class="filters-form">
        <div class="filter-row">
            <input type="text" name="search" placeholder="Ara..." value="<?= htmlspecialchars($search) ?>" class="form-control">
            
            <select name="status" class="form-control">
                <option value="">Tüm Durumlar</option>
                <option value="published" <?= $status === 'published' ? 'selected' : '' ?>>Yayında</option>
                <option value="draft" <?= $status === 'draft' ? 'selected' : '' ?>>Taslak</option>
            </select>
            
            <button type="submit" class="btn btn-secondary">Filtrele</button>
            <a href="/admin/pages.php" class="btn btn-outline">Temizle</a>
        </div>
    </form>
</div>

<!-- Pages Table -->
<div class="card">
    <div class="table-responsive">
        <table class="data-table">
            <thead>
                <tr>
                    <th width="50">ID</th>
                    <th>Başlık</th>
                    <th>Şablon</th>
                    <th>Durum</th>
                    <th>Görüntülenme</th>
                    <th>Sıra</th>
                    <th width="150">İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($pages)): ?>
                    <tr>
                        <td colspan="7" class="text-center">Henüz sayfa yok.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($pages as $p): ?>
                        <tr>
                            <td><?= $p['id'] ?></td>
                            <td>
                                <strong><?= htmlspecialchars($p['title_tr']) ?></strong>
                                <br><small class="text-muted">/<?= $p['slug'] ?></small>
                            </td>
                            <td><?= htmlspecialchars($p['template'] ?: 'default') ?></td>
                            <td>
                                <?php if ($p['status'] === 'published'): ?>
                                    <span class="badge badge-success">Yayında</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Taslak</span>
                                <?php endif; ?>
                            </td>
                            <td><?= number_format($p['views'] ?? 0) ?></td>
                            <td><?= $p['sort_order'] ?></td>
                            <td>
                                <div class="btn-group">
                                    <a href="/admin/page-edit.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-primary">Düzenle</a>
                                    <a href="/<?= $p['slug'] ?>" target="_blank" class="btn btn-sm btn-outline">Gör</a>
                                    <form method="POST" style="display:inline" onsubmit="return confirm('Bu sayfayı silmek istediğinize emin misiniz?')">
                                        <?= csrfField() ?>
                                        <input type="hidden" name="delete_id" value="<?= $p['id'] ?>">
                                        <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <?php if ($totalPages > 1): ?>
        <div class="pagination">
            <?php if ($page > 1): ?>
                <a href="?page=<?= $page - 1 ?>&status=<?= $status ?>&search=<?= urlencode($search) ?>" class="btn btn-sm btn-outline">« Önceki</a>
            <?php endif; ?>
            
            <span class="pagination-info">Sayfa <?= $page ?> / <?= $totalPages ?></span>
            
            <?php if ($page < $totalPages): ?>
                <a href="?page=<?= $page + 1 ?>&status=<?= $status ?>&search=<?= urlencode($search) ?>" class="btn btn-sm btn-outline">Sonraki »</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
