<?php
/**
 * Admin Panel - Dashboard
 */

require_once __DIR__ . '/../includes/config.php';

// Check authentication
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: /admin/login.php');
    exit;
}

// Get stats
$stats = [
    'posts' => $db->getValue("SELECT COUNT(*) FROM posts"),
    'published_posts' => $db->getValue("SELECT COUNT(*) FROM posts WHERE status = 'published'"),
    'pages' => $db->getValue("SELECT COUNT(*) FROM pages WHERE status = 'published'"),
    'categories' => $db->getValue("SELECT COUNT(*) FROM categories"),
    'pending_content' => $db->getValue("SELECT COUNT(*) FROM n8n_content_queue WHERE status = 'pending'"),
    'total_views' => $db->getValue("SELECT SUM(views) FROM posts") + $db->getValue("SELECT SUM(views) FROM pages"),
];

// Recent posts
$recentPosts = $db->getAll("
    SELECT id, title_tr, status, views, created_at 
    FROM posts 
    ORDER BY created_at DESC 
    LIMIT 5
");

// Recent activity
$recentActivity = $db->getAll("
    SELECT * FROM activity_log 
    ORDER BY created_at DESC 
    LIMIT 10
");

// Pending AI content
$pendingContent = $db->getAll("
    SELECT * FROM n8n_content_queue 
    WHERE status = 'pending' 
    ORDER BY created_at DESC 
    LIMIT 5
");

$pageTitle = 'Dashboard';
include __DIR__ . '/includes/header.php';
?>

<div class="dashboard">
    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon" style="background: #3b82f6;">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= number_format($stats['posts']) ?></div>
                <div class="stat-label">Toplam Yazı</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon" style="background: #10b981;">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= number_format($stats['published_posts']) ?></div>
                <div class="stat-label">Yayında</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon" style="background: #8b5cf6;">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    <path d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= number_format($stats['total_views'] ?? 0) ?></div>
                <div class="stat-label">Toplam Görüntülenme</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon" style="background: #f59e0b;">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= number_format($stats['pending_content']) ?></div>
                <div class="stat-label">AI İçerik Bekliyor</div>
            </div>
        </div>
    </div>
    
    <!-- Main Content Grid -->
    <div class="dashboard-grid">
        <!-- Recent Posts -->
        <div class="card">
            <div class="card-header">
                <h3>Son Yazılar</h3>
                <a href="/admin/posts.php" class="btn btn-sm">Tümünü Gör</a>
            </div>
            <div class="card-body">
                <?php if ($recentPosts): ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Başlık</th>
                                <th>Durum</th>
                                <th>Görüntülenme</th>
                                <th>Tarih</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentPosts as $post): ?>
                                <tr>
                                    <td>
                                        <a href="/admin/posts.php?action=edit&id=<?= $post['id'] ?>">
                                            <?= htmlspecialchars(truncate($post['title_tr'], 40)) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?= $post['status'] === 'published' ? 'success' : 'warning' ?>">
                                            <?= $post['status'] === 'published' ? 'Yayında' : 'Taslak' ?>
                                        </span>
                                    </td>
                                    <td><?= number_format($post['views']) ?></td>
                                    <td><?= formatDate($post['created_at']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p class="text-muted">Henüz yazı yok.</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Pending AI Content -->
        <div class="card">
            <div class="card-header">
                <h3>🤖 AI İçerik Kuyruğu</h3>
                <a href="/admin/ai-content.php" class="btn btn-sm">Yönet</a>
            </div>
            <div class="card-body">
                <?php if ($pendingContent): ?>
                    <?php foreach ($pendingContent as $content): ?>
                        <div class="ai-content-item">
                            <div class="ai-content-title">
                                <?= htmlspecialchars(truncate($content['generated_title'], 50)) ?>
                            </div>
                            <div class="ai-content-meta">
                                <span>📝 <?= htmlspecialchars($content['source_keyword']) ?></span>
                                <span>🕐 <?= timeAgo($content['created_at']) ?></span>
                            </div>
                            <div class="ai-content-actions">
                                <a href="/admin/ai-content.php?action=review&id=<?= $content['id'] ?>" class="btn btn-sm btn-primary">İncele</a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">Bekleyen AI içerik yok.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Quick Actions -->
    <div class="card">
        <div class="card-header">
            <h3>Hızlı İşlemler</h3>
        </div>
        <div class="card-body">
            <div class="quick-actions">
                <a href="/admin/posts.php?action=new" class="quick-action">
                    <span class="quick-action-icon">📝</span>
                    <span>Yeni Yazı</span>
                </a>
                <a href="/admin/pages.php?action=new" class="quick-action">
                    <span class="quick-action-icon">📄</span>
                    <span>Yeni Sayfa</span>
                </a>
                <a href="/admin/media.php" class="quick-action">
                    <span class="quick-action-icon">🖼️</span>
                    <span>Medya Yükle</span>
                </a>
                <a href="/admin/seo.php" class="quick-action">
                    <span class="quick-action-icon">🔍</span>
                    <span>SEO Analizi</span>
                </a>
                <a href="/admin/settings.php" class="quick-action">
                    <span class="quick-action-icon">⚙️</span>
                    <span>Ayarlar</span>
                </a>
                <a href="/admin/backup.php" class="quick-action">
                    <span class="quick-action-icon">💾</span>
                    <span>Yedekleme</span>
                </a>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
