<?php
/**
 * Home Page Template
 * Cliniq Theme Clone
 */

// Get data from View
$featuredPosts = View::get('featuredPosts', []);
$latestPosts = View::get('latestPosts', []);
$services = View::get('services', []);
$faqs = View::get('faqs', []);
$videos = View::get('videos', []);
$reviews = View::get('reviews', []);
$lang = CURRENT_LANG;

// Include header
View::partial('header');
?>

<!-- Hero Section -->
<section class="hero">
    <div class="hero-bg">
        <div class="hero-shape hero-shape-1"></div>
        <div class="hero-shape hero-shape-2"></div>
    </div>
    <div class="container">
        <div class="hero-content">
            <div class="hero-text" data-aos="fade-right">
                <h1>Op. Dr. Özgür Oktay Nar</h1>
                <p class="hero-subtitle">
                    <?= $lang === 'tr' 
                        ? 'Bursa\'daki özel muayenehanemde, siz değerli hastalarımı en güncel ve etkili tedavi yöntemleriyle sağlığına kavuşturmak için hizmet veriyorum.'
                        : 'I serve in my private practice in Bursa to bring you, my valued patients, to your health with the most up-to-date and effective treatment methods.'
                    ?>
                </p>
                <div class="hero-buttons">
                    <a href="https://wa.me/905522493909" class="btn btn-primary" target="_blank">
                        <i class="icon-whatsapp"></i>
                        <?= $lang === 'tr' ? 'İletişime Geç' : 'Contact Us' ?>
                    </a>
                    <a href="https://www.doktortakvimi.com/ozgur-oktay-nar/ortopedi-ve-travmatoloji/bursa" class="btn btn-secondary" target="_blank">
                        <?= $lang === 'tr' ? 'Randevu Al' : 'Make an Appointment' ?>
                    </a>
                </div>
            </div>
            <div class="hero-image" data-aos="fade-left">
                <img src="<?= asset('images/doctor-hero.webp') ?>" alt="Op. Dr. Özgür Oktay Nar" loading="lazy">
            </div>
        </div>
        
        <!-- Quick Links -->
        <div class="hero-quick-links" data-aos="fade-up">
            <a href="<?= langUrl('uzmanlik-alanlari') ?>" class="quick-link">
                <span class="quick-link-icon">🩺</span>
                <span><?= $lang === 'tr' ? 'Uzmanlık Alanları' : 'Areas Of Specialization' ?></span>
            </a>
            <a href="https://www.doktortakvimi.com/ozgur-oktay-nar/ortopedi-ve-travmatoloji/bursa" class="quick-link" target="_blank">
                <span class="quick-link-icon">📅</span>
                <span><?= $lang === 'tr' ? 'Randevu Al' : 'Make an Appointment' ?></span>
            </a>
            <a href="tel:+905398416801" class="quick-link">
                <span class="quick-link-icon">📞</span>
                <span>+90 539 841 68 01</span>
            </a>
        </div>
    </div>
</section>

<!-- About Section -->
<section class="about-section section">
    <div class="container">
        <div class="about-grid">
            <div class="about-image" data-aos="fade-right">
                <img src="<?= asset('images/doctor-about.webp') ?>" alt="Op. Dr. Özgür Oktay Nar">
                <div class="about-dots"></div>
                <div class="about-circle"></div>
            </div>
            <div class="about-content" data-aos="fade-left">
                <span class="section-tag"><?= $lang === 'tr' ? 'Hakkımda' : 'About me' ?></span>
                <h2><?= $lang === 'tr' ? 'Op. Dr. Özgür Oktay Nar Kimdir?' : 'Who is Op. Dr. Özgür Oktay Nar?' ?></h2>
                <p>
                    <?= $lang === 'tr' 
                        ? 'Op. Dr. Özgür Oktay Nar, ortopedi ve travmatoloji alanında uzmanlaşmış, hastalarına bireysel ihtiyaçlarına göre çözümler sunma ilkesini benimseyen bir hekimdir. 1978 yılında Adana\'da doğan Dr. Nar, tıp eğitimini Samsun 19 Mayıs Üniversitesi Tıp Fakültesi\'nde tamamlamış ve ortopedi ve travmatoloji uzmanlık eğitimini Kahramanmaraş Sütçü İmam Üniversitesi\'nde başarıyla bitirmiştir.'
                        : 'Op. Dr. Özgür Oktay Nar is a physician who specializes in orthopedics and traumatology and has adopted the principle of providing solutions to his patients according to their individual needs. Born in 1978 in Adana, Dr. Nar completed his medical education at Samsun 19 Mayıs University Faculty of Medicine and successfully completed his specialty training in orthopedics and traumatology at Kahramanmaraş Sütçü İmam University.'
                    ?>
                </p>
                <a href="<?= langUrl('hakkimda') ?>" class="btn btn-outline">
                    <?= $lang === 'tr' ? 'Devamını Oku' : 'Read More' ?>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="services-section section bg-light">
    <div class="container">
        <div class="section-header" data-aos="fade-up">
            <span class="section-tag"><?= $lang === 'tr' ? 'Uzmanlık Alanları' : 'Areas Of Specialization' ?></span>
            <h2><?= $lang === 'tr' ? 'Tedavi Hizmetlerimiz' : 'Our Treatment Services' ?></h2>
        </div>
        
        <div class="services-grid">
            <?php
            $defaultServices = [
                ['icon' => 'bandage', 'title_tr' => 'Ayak ve Ayak Bileği', 'title_en' => 'Foot and Ankle', 'slug' => 'ayak-ve-ayak-bilegi', 'desc_tr' => 'Hareketliliğinizi artıran ve yaşam kalitenizi iyileştiren özel tedaviler sunuyoruz.', 'desc_en' => 'We offer customized treatments for foot and ankle problems that increase your mobility.'],
                ['icon' => 'scoliosis', 'title_tr' => 'Duruş Bozukluğu', 'title_en' => 'Posture Disorder', 'slug' => 'durus-bozuklugu', 'desc_tr' => 'Duruş bozukluklarınızı düzeltmek için bireysel değerlendirmeler sunuyoruz.', 'desc_en' => 'We offer individual assessments to correct your posture disorders.'],
                ['icon' => 'knee', 'title_tr' => 'Diz', 'title_en' => 'Knee', 'slug' => 'diz-hastaliklari', 'desc_tr' => 'Diz rahatsızlıklarınızı gidermek için kişiye özel tedavi çözümleri sunuyoruz.', 'desc_en' => 'We offer personalized treatment solutions to relieve your knee discomfort.'],
                ['icon' => 'hip', 'title_tr' => 'Kalça', 'title_en' => 'Hip', 'slug' => 'kalca-hastaliklari', 'desc_tr' => 'Kalça eklem sorunlarınızı gidermek için modern tedavi yöntemleri sunuyoruz.', 'desc_en' => 'We offer modern treatment methods to relieve your hip joint problems.'],
                ['icon' => 'shoulder', 'title_tr' => 'Omuz', 'title_en' => 'Shoulder', 'slug' => 'omuz-hastaliklari', 'desc_tr' => 'Omuz rahatsızlıklarınız için özelleştirilmiş tedavi çözümleri sunuyoruz.', 'desc_en' => 'We offer customized treatment solutions for your shoulder conditions.'],
                ['icon' => 'spine', 'title_tr' => 'Boyun - Sırt - Bel', 'title_en' => 'Neck - Back - Waist', 'slug' => 'boyun-sirt-bel', 'desc_tr' => 'Boyun, sırt ve bel ağrılarınızı gidermek için yanınızdayız.', 'desc_en' => 'We are at your side to relieve your neck, back and lower back pain.'],
                ['icon' => 'elbow', 'title_tr' => 'Dirsek', 'title_en' => 'Elbow', 'slug' => 'dirsek-hastaliklari', 'desc_tr' => 'Dirsek sorunlarınızı teşhis ve tedavi etmek için kapsamlı çözümler sunuyoruz.', 'desc_en' => 'We offer comprehensive solutions to diagnose and treat your elbow problems.'],
                ['icon' => 'hand', 'title_tr' => 'El - Bilek', 'title_en' => 'Hand - Wrist', 'slug' => 'el-bilek-hastaliklari', 'desc_tr' => 'El ve bilek sorunlarınızı çözmek için en uygun tedavi yöntemlerini sunuyoruz.', 'desc_en' => 'We offer the most appropriate treatment methods to solve your hand and wrist problems.'],
                ['icon' => 'joints', 'title_tr' => 'Eklem Ağrıları', 'title_en' => 'Joint Pains', 'slug' => 'eklem-agrilari', 'desc_tr' => 'Eklem ağrılarınızı gidermek için kapsamlı tedavi seçenekleri sunuyoruz.', 'desc_en' => 'We offer a comprehensive range of treatment options to relieve your joint pain.'],
            ];
            
            foreach ($defaultServices as $index => $service):
            ?>
                <div class="service-card" data-aos="fade-up" data-aos-delay="<?= $index * 100 ?>">
                    <div class="service-icon">
                        <img src="<?= asset('images/icons/' . $service['icon'] . '.svg') ?>" alt="<?= $service['title_' . $lang] ?>">
                    </div>
                    <h3><?= $service['title_' . $lang] ?></h3>
                    <p><?= $service['desc_' . $lang] ?></p>
                    <a href="<?= langUrl('uzmanlik-alanlari/' . $service['slug']) ?>" class="service-link">
                        <?= $lang === 'tr' ? 'Devamını Oku' : 'Read More' ?> →
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="features-section section">
    <div class="container">
        <div class="features-grid">
            <div class="features-content" data-aos="fade-right">
                <span class="section-tag"><?= $lang === 'tr' ? 'Yenilikçi, Hızlı, Etkili' : 'Innovative, Fast, Effective' ?></span>
                <h2><?= $lang === 'tr' ? 'Yenilikçi Tedavilerle Cerrahi Deneyim' : 'Surgical Experience with Innovative Treatments' ?></h2>
                
                <div class="feature-item">
                    <span class="feature-number">01</span>
                    <div class="feature-text">
                        <h4><?= $lang === 'tr' ? 'Yenilikçi Cerrahi Teknikler' : 'Innovative Surgical Techniques' ?></h4>
                        <p><?= $lang === 'tr' 
                            ? 'Minimal invaziv ve artroskopik cerrahi gibi yenilikçi tekniklerle hastalarımıza daha az ağrı ve daha kısa iyileşme süresi sunuyoruz.'
                            : 'We offer our patients less pain and shorter recovery times with innovative techniques such as minimally invasive and arthroscopic surgery.'
                        ?></p>
                    </div>
                </div>
                
                <div class="feature-item">
                    <span class="feature-number">02</span>
                    <div class="feature-text">
                        <h4><?= $lang === 'tr' ? 'Bilime Dayalı Yaklaşımlar' : 'Science-based Approaches' ?></h4>
                        <p><?= $lang === 'tr' 
                            ? 'Bilimsel araştırmalara dayanan yaklaşımlarla hastalarımıza en doğru tanı ve tedavi planlarını sunuyoruz.'
                            : 'We offer the most accurate diagnosis and treatment plans with approaches based on scientific research.'
                        ?></p>
                    </div>
                </div>
                
                <div class="feature-item">
                    <span class="feature-number">03</span>
                    <div class="feature-text">
                        <h4><?= $lang === 'tr' ? 'Yüksek Kaliteli Ortopedik Tedavi' : 'High Quality Orthopedic Treatment' ?></h4>
                        <p><?= $lang === 'tr' 
                            ? 'Her hastanın ihtiyaçlarına göre özel tedavi planları oluşturuyor, en güncel ve etkili ortopedik yöntemleri uyguluyoruz.'
                            : 'We create special treatment plans according to the needs of each patient and apply the most up-to-date orthopedic methods.'
                        ?></p>
                    </div>
                </div>
            </div>
            <div class="features-image" data-aos="fade-left">
                <img src="<?= asset('images/features-doctor.webp') ?>" alt="Op. Dr. Özgür Oktay Nar">
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <div class="cta-content" data-aos="fade-up">
            <h2><?= $lang === 'tr' ? 'Hareketin Gücüyle Sağlığınızı Yenileyin!' : 'Renew Your Health with the Power of Movement!' ?></h2>
            <a href="https://www.doktortakvimi.com/ozgur-oktay-nar/ortopedi-ve-travmatoloji/bursa" class="btn btn-white" target="_blank">
                <?= $lang === 'tr' ? 'Randevu Al' : 'Make an Appointment' ?>
            </a>
        </div>
    </div>
</section>

<!-- Videos Section -->
<?php if (!empty($videos)): ?>
<section class="videos-section section bg-light">
    <div class="container">
        <div class="section-header" data-aos="fade-up">
            <span class="section-tag">YouTube</span>
            <h2><?= $lang === 'tr' ? 'Videolarım' : 'My Videos' ?></h2>
        </div>
        
        <div class="videos-slider" data-aos="fade-up">
            <?php foreach ($videos as $video): ?>
                <div class="video-card">
                    <div class="video-thumbnail" data-youtube="<?= $video['youtube_id'] ?>">
                        <img src="<?= $video['thumbnail_hq'] ?: 'https://img.youtube.com/vi/' . $video['youtube_id'] . '/maxresdefault.jpg' ?>" alt="<?= localized($video, 'title') ?>">
                        <div class="video-play">
                            <svg viewBox="0 0 24 24"><path d="M8 5v14l11-7z"/></svg>
                        </div>
                        <span class="video-duration"><?= $video['duration'] ?></span>
                    </div>
                    <h4><?= localized($video, 'title') ?></h4>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Blog Section -->
<?php if (!empty($latestPosts)): ?>
<section class="blog-section section">
    <div class="container">
        <div class="section-header" data-aos="fade-up">
            <span class="section-tag">Blog</span>
            <h2><?= $lang === 'tr' ? 'Yazılar' : 'Articles' ?></h2>
        </div>
        
        <div class="blog-grid">
            <?php foreach (array_slice($latestPosts, 0, 3) as $index => $post): ?>
                <article class="blog-card" data-aos="fade-up" data-aos-delay="<?= $index * 100 ?>">
                    <a href="<?= langUrl('blog/' . $post['slug']) ?>" class="blog-image">
                        <?php if ($post['featured_image']): ?>
                            <img src="<?= uploadUrl($post['featured_image']) ?>" alt="<?= localized($post, 'title') ?>" loading="lazy">
                        <?php else: ?>
                            <img src="<?= asset('images/blog-placeholder.webp') ?>" alt="<?= localized($post, 'title') ?>" loading="lazy">
                        <?php endif; ?>
                    </a>
                    <div class="blog-content">
                        <time datetime="<?= $post['published_at'] ?>"><?= formatDate($post['published_at']) ?></time>
                        <h3><a href="<?= langUrl('blog/' . $post['slug']) ?>"><?= localized($post, 'title') ?></a></h3>
                        <p><?= truncate(localized($post, 'excerpt'), 120) ?></p>
                        <a href="<?= langUrl('blog/' . $post['slug']) ?>" class="read-more">
                            <?= $lang === 'tr' ? 'Devamını Oku' : 'Read More' ?> →
                        </a>
                    </div>
                </article>
            <?php endforeach; ?>
        </div>
        
        <div class="section-footer" data-aos="fade-up">
            <a href="<?= langUrl('blog') ?>" class="btn btn-outline">
                <?= $lang === 'tr' ? 'Tüm Yazılar' : 'All Articles' ?>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Reviews Section -->
<?php if (!empty($reviews)): ?>
<section class="reviews-section section bg-light">
    <div class="container">
        <div class="section-header" data-aos="fade-up">
            <span class="section-tag">Google Reviews</span>
            <h2><?= $lang === 'tr' ? 'Hasta Yorumları' : 'Patient Reviews' ?></h2>
        </div>
        
        <div class="reviews-slider" data-aos="fade-up">
            <?php foreach ($reviews as $review): ?>
                <div class="review-card">
                    <div class="review-header">
                        <div class="review-author">
                            <?php if ($review['author_photo']): ?>
                                <img src="<?= $review['author_photo'] ?>" alt="<?= $review['author_name'] ?>">
                            <?php else: ?>
                                <div class="author-avatar"><?= mb_substr($review['author_name'], 0, 1) ?></div>
                            <?php endif; ?>
                            <div>
                                <strong><?= $review['author_name'] ?></strong>
                                <span class="review-date"><?= $review['relative_time'] ?></span>
                            </div>
                        </div>
                        <div class="review-rating">
                            <?php for ($i = 0; $i < 5; $i++): ?>
                                <span class="star <?= $i < $review['rating'] ? 'filled' : '' ?>">★</span>
                            <?php endfor; ?>
                        </div>
                    </div>
                    <p class="review-text"><?= $review['text'] ?></p>
                    <div class="review-source">
                        <img src="<?= asset('images/google-icon.svg') ?>" alt="Google">
                        <span>Google</span>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- FAQ Section -->
<?php if (!empty($faqs)): ?>
<section class="faq-section section">
    <div class="container">
        <div class="section-header" data-aos="fade-up">
            <span class="section-tag"><?= $lang === 'tr' ? 'SSS' : 'FAQ' ?></span>
            <h2><?= $lang === 'tr' ? 'Merak Edilenler' : 'Curiosities' ?></h2>
        </div>
        
        <div class="faq-list" data-aos="fade-up">
            <?php foreach ($faqs as $index => $faq): ?>
                <div class="faq-item <?= $index === 0 ? 'active' : '' ?>">
                    <button class="faq-question">
                        <span><?= localized($faq, 'question') ?></span>
                        <svg class="faq-icon" viewBox="0 0 24 24"><path d="M19 9l-7 7-7-7"/></svg>
                    </button>
                    <div class="faq-answer">
                        <div class="faq-answer-content">
                            <?= localized($faq, 'answer') ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Contact Info Section -->
<section class="contact-info-section">
    <div class="container">
        <div class="contact-grid">
            <div class="contact-item" data-aos="fade-up">
                <div class="contact-icon">📍</div>
                <div class="contact-text">
                    <a href="https://maps.app.goo.gl/j57YL1Dwd6QsEsgB9" target="_blank">
                        Bağlarbaşı Mah. Sanayi Cad. 348/B No:46 (Opus Evke Plaza) Osmangazi / BURSA
                    </a>
                </div>
            </div>
            <div class="contact-item" data-aos="fade-up" data-aos-delay="100">
                <div class="contact-icon">📧</div>
                <div class="contact-text">
                    <a href="mailto:ozguroktaynar@gmail.com">ozguroktaynar@gmail.com</a>
                </div>
            </div>
            <div class="contact-item" data-aos="fade-up" data-aos-delay="200">
                <div class="contact-icon">📞</div>
                <div class="contact-text">
                    <a href="tel:+905398416801">+90 539 841 68 01</a>
                </div>
            </div>
            <div class="contact-item" data-aos="fade-up" data-aos-delay="300">
                <div class="contact-icon">🕐</div>
                <div class="contact-text">
                    <strong><?= $lang === 'tr' ? 'Çalışma Saatleri' : 'Working Hours' ?></strong><br>
                    <?= $lang === 'tr' ? 'Pzt-Cuma: 10:00-17:00' : 'Mon-Fri: 10:00-17:00' ?><br>
                    <?= $lang === 'tr' ? 'Cumartesi: 10:00-14:00' : 'Saturday: 10:00-14:00' ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php View::partial('footer'); ?>
