<?php
/**
 * Header Template
 */

$lang = CURRENT_LANG;
$siteName = getSetting('site_name_' . $lang, 'Op. Dr. Özgür Oktay Nar');
$pageTitle = View::get('pageTitle', $siteName);
$metaDescription = View::get('metaDescription', getSetting('site_description_' . $lang));
$ogImage = View::get('ogImage', getSetting('default_og_image'));
?>
<!DOCTYPE html>
<html lang="<?= $lang ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- SEO Meta -->
    <title><?= htmlspecialchars(metaTitle($pageTitle)) ?></title>
    <meta name="description" content="<?= htmlspecialchars($metaDescription) ?>">
    <link rel="canonical" href="<?= canonicalUrl() ?>">
    
    <!-- Open Graph -->
    <meta property="og:title" content="<?= htmlspecialchars($pageTitle) ?>">
    <meta property="og:description" content="<?= htmlspecialchars($metaDescription) ?>">
    <meta property="og:image" content="<?= $ogImage ? url($ogImage) : '' ?>">
    <meta property="og:url" content="<?= canonicalUrl() ?>">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="<?= $lang === 'tr' ? 'tr_TR' : 'en_US' ?>">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?= htmlspecialchars($pageTitle) ?>">
    <meta name="twitter:description" content="<?= htmlspecialchars($metaDescription) ?>">
    
    <!-- Favicon -->
    <link rel="icon" href="<?= asset('images/favicon.ico') ?>">
    <link rel="apple-touch-icon" href="<?= asset('images/apple-touch-icon.png') ?>">
    
    <!-- Preconnect -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <!-- Swiper Slider -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
    
    <!-- Main CSS -->
    <link rel="stylesheet" href="<?= asset('css/style.css') ?>">
    
    <!-- Facebook Pixel -->
    <?php if ($fbPixel = getSetting('facebook_pixel_id')): ?>
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '<?= $fbPixel ?>');
    fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=<?= $fbPixel ?>&ev=PageView&noscript=1"/></noscript>
    <?php endif; ?>
    
    <!-- Google Analytics -->
    <?php if ($gaId = getSetting('ga4_measurement_id')): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?= $gaId ?>"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', '<?= $gaId ?>');
    </script>
    <?php endif; ?>
    
    <!-- Schema.org -->
    <?= schemaOrg([
        '@context' => 'https://schema.org',
        '@type' => 'MedicalBusiness',
        'name' => 'Op. Dr. Özgür Oktay Nar',
        'description' => getSetting('site_description_tr'),
        'url' => SITE_URL,
        'telephone' => getSetting('site_phone'),
        'email' => getSetting('site_email'),
        'address' => [
            '@type' => 'PostalAddress',
            'streetAddress' => 'Bağlarbaşı Mah. Sanayi Cad. 348/B No:46',
            'addressLocality' => 'Osmangazi',
            'addressRegion' => 'Bursa',
            'addressCountry' => 'TR'
        ],
        'openingHours' => ['Mo-Fr 10:00-17:00', 'Sa 10:00-14:00'],
        'medicalSpecialty' => 'Orthopedic',
        'sameAs' => [
            getSetting('social_instagram'),
            getSetting('social_facebook'),
            getSetting('social_youtube')
        ]
    ]) ?>
</head>
<body>
    <!-- Skip to content -->
    <a href="#content" class="skip-link"><?= $lang === 'tr' ? 'İçeriğe atla' : 'Skip to content' ?></a>
    
    <!-- Header -->
    <header class="header" id="header">
        <div class="container">
            <div class="header-inner">
                <!-- Logo -->
                <a href="<?= langUrl('/') ?>" class="logo">
                    <img src="<?= asset('images/logo.webp') ?>" alt="<?= $siteName ?>">
                </a>
                
                <!-- Navigation -->
                <nav class="main-nav" id="mainNav">
                    <ul class="nav-menu">
                        <li><a href="<?= langUrl('/') ?>" class="<?= $_SERVER['REQUEST_URI'] === '/' || $_SERVER['REQUEST_URI'] === '/en' ? 'active' : '' ?>"><?= $lang === 'tr' ? 'Ana Sayfa' : 'Home' ?></a></li>
                        <li><a href="<?= langUrl('hakkimda') ?>"><?= $lang === 'tr' ? 'Hakkımda' : 'About me' ?></a></li>
                        <li><a href="<?= langUrl('uzmanlik-alanlari') ?>"><?= $lang === 'tr' ? 'Uzmanlık Alanları' : 'Areas of Specialization' ?></a></li>
                        <li><a href="<?= langUrl('blog') ?>">Blog</a></li>
                        <li><a href="<?= langUrl('iletisim') ?>"><?= $lang === 'tr' ? 'İletişim' : 'Contact' ?></a></li>
                    </ul>
                </nav>
                
                <!-- Header Actions -->
                <div class="header-actions">
                    <!-- Language Switcher -->
                    <div class="lang-switch">
                        <a href="<?= switchLangUrl($lang === 'tr' ? 'en' : 'tr') ?>" class="lang-btn">
                            <?= $lang === 'tr' ? 'EN' : 'TR' ?>
                        </a>
                    </div>
                    
                    <!-- Appointment Button -->
                    <a href="https://www.doktortakvimi.com/ozgur-oktay-nar/ortopedi-ve-travmatoloji/bursa" class="btn btn-primary header-cta" target="_blank">
                        <?= $lang === 'tr' ? 'Randevu Al' : 'Make an Appointment' ?>
                    </a>
                    
                    <!-- Mobile Menu Toggle -->
                    <button class="mobile-menu-toggle" id="mobileMenuToggle" aria-label="Menu">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Mobile Menu -->
    <div class="mobile-menu" id="mobileMenu">
        <div class="mobile-menu-inner">
            <ul class="mobile-nav">
                <li><a href="<?= langUrl('/') ?>"><?= $lang === 'tr' ? 'Ana Sayfa' : 'Home' ?></a></li>
                <li><a href="<?= langUrl('hakkimda') ?>"><?= $lang === 'tr' ? 'Hakkımda' : 'About me' ?></a></li>
                <li><a href="<?= langUrl('uzmanlik-alanlari') ?>"><?= $lang === 'tr' ? 'Uzmanlık Alanları' : 'Areas of Specialization' ?></a></li>
                <li><a href="<?= langUrl('blog') ?>">Blog</a></li>
                <li><a href="<?= langUrl('iletisim') ?>"><?= $lang === 'tr' ? 'İletişim' : 'Contact' ?></a></li>
            </ul>
            <div class="mobile-menu-footer">
                <a href="https://www.doktortakvimi.com/ozgur-oktay-nar/ortopedi-ve-travmatoloji/bursa" class="btn btn-primary btn-block" target="_blank">
                    <?= $lang === 'tr' ? 'Randevu Al' : 'Make an Appointment' ?>
                </a>
                <div class="mobile-lang">
                    <a href="<?= switchLangUrl('tr') ?>" class="<?= $lang === 'tr' ? 'active' : '' ?>">TR</a>
                    <a href="<?= switchLangUrl('en') ?>" class="<?= $lang === 'en' ? 'active' : '' ?>">EN</a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <main id="content">
