<?php
/**
 * Blog Single Post Template
 */

$post = View::get('post');
$relatedPosts = View::get('relatedPosts', []);
$categories = View::get('categories', []);
$lang = CURRENT_LANG;

if (!$post) {
    header('Location: ' . langUrl('blog'));
    exit;
}

// Set page meta
View::set('pageTitle', localized($post, 'meta_title') ?: localized($post, 'title'));
View::set('metaDescription', localized($post, 'meta_description') ?: truncate(strip_tags(localized($post, 'excerpt')), 160));
View::set('ogImage', $post['featured_image'] ? uploadUrl($post['featured_image']) : null);

View::partial('header');
?>

<!-- Article Schema -->
<?= schemaOrg([
    '@context' => 'https://schema.org',
    '@type' => 'Article',
    'headline' => localized($post, 'title'),
    'description' => localized($post, 'excerpt'),
    'image' => $post['featured_image'] ? uploadUrl($post['featured_image']) : null,
    'datePublished' => $post['published_at'],
    'dateModified' => $post['updated_at'],
    'author' => [
        '@type' => 'Person',
        'name' => 'Op. Dr. Özgür Oktay Nar'
    ],
    'publisher' => [
        '@type' => 'Organization',
        'name' => 'Op. Dr. Özgür Oktay Nar',
        'logo' => [
            '@type' => 'ImageObject',
            'url' => asset('images/logo.webp')
        ]
    ]
]) ?>

<!-- Breadcrumb -->
<nav class="breadcrumb-nav">
    <div class="container">
        <ol class="breadcrumb" itemscope itemtype="https://schema.org/BreadcrumbList">
            <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                <a itemprop="item" href="<?= langUrl('/') ?>">
                    <span itemprop="name"><?= $lang === 'tr' ? 'Ana Sayfa' : 'Home' ?></span>
                </a>
                <meta itemprop="position" content="1">
            </li>
            <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                <a itemprop="item" href="<?= langUrl('blog') ?>">
                    <span itemprop="name">Blog</span>
                </a>
                <meta itemprop="position" content="2">
            </li>
            <?php if ($post['category_name']): ?>
                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                    <a itemprop="item" href="<?= langUrl('blog/kategori/' . $post['category_slug']) ?>">
                        <span itemprop="name"><?= $post['category_name'] ?></span>
                    </a>
                    <meta itemprop="position" content="3">
                </li>
            <?php endif; ?>
            <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                <span itemprop="name"><?= truncate(localized($post, 'title'), 50) ?></span>
                <meta itemprop="position" content="<?= $post['category_name'] ? '4' : '3' ?>">
            </li>
        </ol>
    </div>
</nav>

<!-- Article -->
<article class="article-page">
    <!-- Article Header -->
    <header class="article-header">
        <div class="container">
            <div class="article-meta">
                <?php if ($post['category_name']): ?>
                    <a href="<?= langUrl('blog/kategori/' . $post['category_slug']) ?>" class="article-category">
                        <?= $post['category_name'] ?>
                    </a>
                <?php endif; ?>
                <time datetime="<?= $post['published_at'] ?>"><?= formatDate($post['published_at']) ?></time>
                <span class="reading-time">
                    <?= estimateReadingTime(localized($post, 'content')) ?> <?= $lang === 'tr' ? 'dk okuma' : 'min read' ?>
                </span>
            </div>
            <h1><?= localized($post, 'title') ?></h1>
            <div class="article-author">
                <img src="<?= asset('images/doctor-avatar.webp') ?>" alt="Op. Dr. Özgür Oktay Nar">
                <div>
                    <strong>Op. Dr. Özgür Oktay Nar</strong>
                    <span><?= $lang === 'tr' ? 'Ortopedi ve Travmatoloji Uzmanı' : 'Orthopedics and Traumatology Specialist' ?></span>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Featured Image -->
    <?php if ($post['featured_image']): ?>
        <div class="article-featured-image">
            <div class="container">
                <img src="<?= uploadUrl($post['featured_image']) ?>" alt="<?= localized($post, 'title') ?>">
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Article Content -->
    <div class="article-content-wrapper">
        <div class="container">
            <div class="article-layout">
                <!-- Main Content -->
                <div class="article-content prose">
                    <?= localized($post, 'content') ?>
                </div>
                
                <!-- Sidebar -->
                <aside class="article-sidebar">
                    <!-- Share -->
                    <div class="sidebar-widget">
                        <h3><?= $lang === 'tr' ? 'Paylaş' : 'Share' ?></h3>
                        <div class="share-buttons">
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode(canonicalUrl()) ?>" 
                               target="_blank" class="share-btn share-facebook" aria-label="Facebook">
                                <svg viewBox="0 0 24 24" width="20" height="20"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" fill="currentColor"/></svg>
                            </a>
                            <a href="https://twitter.com/intent/tweet?url=<?= urlencode(canonicalUrl()) ?>&text=<?= urlencode(localized($post, 'title')) ?>" 
                               target="_blank" class="share-btn share-twitter" aria-label="Twitter">
                                <svg viewBox="0 0 24 24" width="20" height="20"><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z" fill="currentColor"/></svg>
                            </a>
                            <a href="https://wa.me/?text=<?= urlencode(localized($post, 'title') . ' - ' . canonicalUrl()) ?>" 
                               target="_blank" class="share-btn share-whatsapp" aria-label="WhatsApp">
                                <svg viewBox="0 0 24 24" width="20" height="20"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z" fill="currentColor"/></svg>
                            </a>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?= urlencode(canonicalUrl()) ?>&title=<?= urlencode(localized($post, 'title')) ?>" 
                               target="_blank" class="share-btn share-linkedin" aria-label="LinkedIn">
                                <svg viewBox="0 0 24 24" width="20" height="20"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z" fill="currentColor"/></svg>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Table of Contents (generated by JS) -->
                    <div class="sidebar-widget toc-widget" id="tableOfContents">
                        <h3><?= $lang === 'tr' ? 'İçindekiler' : 'Table of Contents' ?></h3>
                        <nav class="toc-nav"></nav>
                    </div>
                    
                    <!-- Contact CTA -->
                    <div class="sidebar-widget sidebar-cta">
                        <h3><?= $lang === 'tr' ? 'Uzman Görüşü Alın' : 'Get Expert Opinion' ?></h3>
                        <p><?= $lang === 'tr' 
                            ? 'Bu konu hakkında sorularınız mı var? Hemen iletişime geçin.'
                            : 'Do you have questions about this topic? Contact us now.'
                        ?></p>
                        <a href="https://www.doktortakvimi.com/ozgur-oktay-nar/ortopedi-ve-travmatoloji/bursa" class="btn btn-primary btn-block" target="_blank">
                            <?= $lang === 'tr' ? 'Randevu Al' : 'Make an Appointment' ?>
                        </a>
                    </div>
                </aside>
            </div>
        </div>
    </div>
    
    <!-- Tags -->
    <?php if (!empty($post['tags'])): ?>
        <div class="article-tags">
            <div class="container">
                <span><?= $lang === 'tr' ? 'Etiketler:' : 'Tags:' ?></span>
                <?php foreach ($post['tags'] as $tag): ?>
                    <a href="<?= langUrl('blog/etiket/' . $tag['slug']) ?>">#<?= localized($tag, 'name') ?></a>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</article>

<!-- Related Posts -->
<?php if (!empty($relatedPosts)): ?>
    <section class="related-posts section bg-light">
        <div class="container">
            <h2><?= $lang === 'tr' ? 'İlgili Yazılar' : 'Related Articles' ?></h2>
            <div class="blog-grid">
                <?php foreach ($relatedPosts as $related): ?>
                    <article class="blog-card">
                        <a href="<?= langUrl('blog/' . $related['slug']) ?>" class="blog-image">
                            <?php if ($related['featured_image']): ?>
                                <img src="<?= uploadUrl($related['featured_image']) ?>" alt="<?= localized($related, 'title') ?>" loading="lazy">
                            <?php else: ?>
                                <img src="<?= asset('images/blog-placeholder.webp') ?>" alt="<?= localized($related, 'title') ?>" loading="lazy">
                            <?php endif; ?>
                        </a>
                        <div class="blog-content">
                            <time datetime="<?= $related['published_at'] ?>"><?= formatDate($related['published_at']) ?></time>
                            <h3><a href="<?= langUrl('blog/' . $related['slug']) ?>"><?= localized($related, 'title') ?></a></h3>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<style>
.breadcrumb-nav {
    background: var(--bg-light);
    padding: 16px 0;
}

.breadcrumb {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    font-size: 0.875rem;
}

.breadcrumb li {
    display: flex;
    align-items: center;
}

.breadcrumb li:not(:last-child)::after {
    content: '›';
    margin-left: 8px;
    color: var(--text-light);
}

.breadcrumb a {
    color: var(--text-secondary);
}

.breadcrumb a:hover {
    color: var(--primary);
}

.breadcrumb li:last-child {
    color: var(--text-primary);
    font-weight: 500;
}

.article-header {
    text-align: center;
    padding: 60px 0 40px;
}

.article-meta {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 16px;
    margin-bottom: 20px;
    font-size: 0.875rem;
    color: var(--text-secondary);
}

.article-category {
    background: rgba(8, 145, 178, 0.1);
    color: var(--primary);
    padding: 4px 12px;
    border-radius: 4px;
    font-weight: 500;
}

.article-header h1 {
    max-width: 800px;
    margin: 0 auto 24px;
}

.article-author {
    display: inline-flex;
    align-items: center;
    gap: 12px;
}

.article-author img {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    object-fit: cover;
}

.article-author strong {
    display: block;
    font-size: 0.9375rem;
}

.article-author span {
    font-size: 0.8125rem;
    color: var(--text-secondary);
}

.article-featured-image {
    margin-bottom: 40px;
}

.article-featured-image img {
    width: 100%;
    max-height: 500px;
    object-fit: cover;
    border-radius: var(--radius-xl);
}

.article-layout {
    display: grid;
    grid-template-columns: 1fr 280px;
    gap: 40px;
}

.article-content.prose {
    font-size: 1.0625rem;
    line-height: 1.8;
    color: var(--text-secondary);
}

.prose h2, .prose h3, .prose h4 {
    color: var(--text-primary);
    margin-top: 32px;
    margin-bottom: 16px;
}

.prose h2 { font-size: 1.5rem; }
.prose h3 { font-size: 1.25rem; }

.prose p {
    margin-bottom: 16px;
}

.prose img {
    border-radius: var(--radius-lg);
    margin: 24px 0;
}

.prose ul, .prose ol {
    margin: 16px 0;
    padding-left: 24px;
}

.prose li {
    margin-bottom: 8px;
}

.prose ul li {
    list-style: disc;
}

.prose ol li {
    list-style: decimal;
}

.prose blockquote {
    border-left: 4px solid var(--primary);
    padding-left: 20px;
    margin: 24px 0;
    font-style: italic;
    color: var(--text-primary);
}

.prose a {
    color: var(--primary);
}

.prose a:hover {
    text-decoration: underline;
}

.article-sidebar {
    position: sticky;
    top: 100px;
    height: fit-content;
}

.share-buttons {
    display: flex;
    gap: 8px;
}

.share-btn {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: var(--radius);
    color: white;
    transition: var(--transition);
}

.share-btn:hover {
    transform: translateY(-2px);
}

.share-facebook { background: #1877f2; }
.share-twitter { background: #1da1f2; }
.share-whatsapp { background: #25d366; }
.share-linkedin { background: #0a66c2; }

.toc-nav {
    font-size: 0.875rem;
}

.toc-nav a {
    display: block;
    padding: 8px 0;
    color: var(--text-secondary);
    border-bottom: 1px solid var(--border-light);
}

.toc-nav a:hover,
.toc-nav a.active {
    color: var(--primary);
}

.article-tags {
    padding: 24px 0;
    border-top: 1px solid var(--border-light);
}

.article-tags span {
    color: var(--text-secondary);
    margin-right: 8px;
}

.article-tags a {
    display: inline-block;
    color: var(--primary);
    margin-right: 8px;
}

.article-tags a:hover {
    text-decoration: underline;
}

.related-posts h2 {
    text-align: center;
    margin-bottom: 40px;
}

.related-posts .blog-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 30px;
}

@media (max-width: 1024px) {
    .article-layout {
        grid-template-columns: 1fr;
    }
    
    .article-sidebar {
        position: static;
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
    }
    
    .toc-widget {
        display: none;
    }
}

@media (max-width: 768px) {
    .article-sidebar {
        grid-template-columns: 1fr;
    }
    
    .related-posts .blog-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
// Generate Table of Contents
document.addEventListener('DOMContentLoaded', function() {
    const content = document.querySelector('.article-content');
    const toc = document.querySelector('.toc-nav');
    const headings = content.querySelectorAll('h2, h3');
    
    if (headings.length > 2 && toc) {
        headings.forEach((heading, index) => {
            const id = 'section-' + index;
            heading.id = id;
            
            const link = document.createElement('a');
            link.href = '#' + id;
            link.textContent = heading.textContent;
            link.style.paddingLeft = heading.tagName === 'H3' ? '16px' : '0';
            
            toc.appendChild(link);
        });
        
        document.getElementById('tableOfContents').style.display = 'block';
    } else {
        document.getElementById('tableOfContents').style.display = 'none';
    }
});
</script>

<?php View::partial('footer'); ?>
