<?php
/**
 * Blog Index Template
 */

$posts = View::get('posts', []);
$categories = View::get('categories', []);
$pagination = View::get('pagination', []);
$currentCategory = View::get('currentCategory', null);
$lang = CURRENT_LANG;

View::partial('header');
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1>Blog</h1>
        <p><?= $lang === 'tr' 
            ? 'Ortopedi ve travmatoloji alanındaki güncel bilgiler, tedavi yöntemleri ve sağlığınıza yönelik ipuçları.'
            : 'Current information in the field of orthopedics and traumatology, treatment methods and tips for your health.'
        ?></p>
    </div>
</section>

<!-- Blog Content -->
<section class="blog-page section">
    <div class="container">
        <div class="blog-layout">
            <!-- Main Content -->
            <div class="blog-main">
                <?php if (!empty($posts)): ?>
                    <div class="blog-grid">
                        <?php foreach ($posts as $post): ?>
                            <article class="blog-card" data-aos="fade-up">
                                <a href="<?= langUrl('blog/' . $post['slug']) ?>" class="blog-image">
                                    <?php if ($post['featured_image']): ?>
                                        <img src="<?= uploadUrl($post['featured_image']) ?>" alt="<?= localized($post, 'title') ?>" loading="lazy">
                                    <?php else: ?>
                                        <img src="<?= asset('images/blog-placeholder.webp') ?>" alt="<?= localized($post, 'title') ?>" loading="lazy">
                                    <?php endif; ?>
                                </a>
                                <div class="blog-content">
                                    <?php if ($post['category_name']): ?>
                                        <a href="<?= langUrl('blog/kategori/' . $post['category_slug']) ?>" class="blog-category">
                                            <?= $post['category_name'] ?>
                                        </a>
                                    <?php endif; ?>
                                    <time datetime="<?= $post['published_at'] ?>"><?= formatDate($post['published_at']) ?></time>
                                    <h2><a href="<?= langUrl('blog/' . $post['slug']) ?>"><?= localized($post, 'title') ?></a></h2>
                                    <p><?= truncate(localized($post, 'excerpt'), 150) ?></p>
                                    <a href="<?= langUrl('blog/' . $post['slug']) ?>" class="read-more">
                                        <?= $lang === 'tr' ? 'Devamını Oku' : 'Read More' ?> →
                                    </a>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    </div>
                    
                    <!-- Pagination -->
                    <?php if ($pagination['total_pages'] > 1): ?>
                        <nav class="pagination" aria-label="Sayfalama">
                            <?php if ($pagination['current_page'] > 1): ?>
                                <a href="<?= langUrl('blog?page=' . ($pagination['current_page'] - 1)) ?>" class="pagination-prev">
                                    ← <?= $lang === 'tr' ? 'Önceki' : 'Previous' ?>
                                </a>
                            <?php endif; ?>
                            
                            <div class="pagination-numbers">
                                <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                                    <?php if ($i == $pagination['current_page']): ?>
                                        <span class="pagination-current"><?= $i ?></span>
                                    <?php else: ?>
                                        <a href="<?= langUrl('blog?page=' . $i) ?>"><?= $i ?></a>
                                    <?php endif; ?>
                                <?php endfor; ?>
                            </div>
                            
                            <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                                <a href="<?= langUrl('blog?page=' . ($pagination['current_page'] + 1)) ?>" class="pagination-next">
                                    <?= $lang === 'tr' ? 'Sonraki' : 'Next' ?> →
                                </a>
                            <?php endif; ?>
                        </nav>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="no-posts">
                        <p><?= $lang === 'tr' ? 'Henüz yazı bulunmuyor.' : 'No posts yet.' ?></p>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Sidebar -->
            <aside class="blog-sidebar">
                <!-- Categories -->
                <?php if (!empty($categories)): ?>
                    <div class="sidebar-widget">
                        <h3><?= $lang === 'tr' ? 'Kategoriler' : 'Categories' ?></h3>
                        <ul class="category-list">
                            <?php foreach ($categories as $category): ?>
                                <li>
                                    <a href="<?= langUrl('blog/kategori/' . $category['slug']) ?>" 
                                       class="<?= ($currentCategory && $currentCategory['id'] == $category['id']) ? 'active' : '' ?>">
                                        <?= localized($category, 'name') ?>
                                        <span class="count">(<?= $category['post_count'] ?>)</span>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <!-- Search -->
                <div class="sidebar-widget">
                    <h3><?= $lang === 'tr' ? 'Arama' : 'Search' ?></h3>
                    <form action="<?= langUrl('arama') ?>" method="GET" class="search-form">
                        <input type="text" name="q" placeholder="<?= $lang === 'tr' ? 'Yazılarda ara...' : 'Search posts...' ?>">
                        <button type="submit">
                            <svg viewBox="0 0 24 24" width="20" height="20"><path d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" stroke="currentColor" stroke-width="2" fill="none"/></svg>
                        </button>
                    </form>
                </div>
                
                <!-- Contact CTA -->
                <div class="sidebar-widget sidebar-cta">
                    <h3><?= $lang === 'tr' ? 'Sorularınız mı var?' : 'Have Questions?' ?></h3>
                    <p><?= $lang === 'tr' 
                        ? 'Ortopedik sorunlarınız hakkında bilgi almak için iletişime geçin.'
                        : 'Contact us for information about your orthopedic problems.'
                    ?></p>
                    <a href="https://wa.me/905522493909" class="btn btn-primary btn-block" target="_blank">
                        <?= $lang === 'tr' ? 'WhatsApp ile İletişim' : 'Contact via WhatsApp' ?>
                    </a>
                </div>
            </aside>
        </div>
    </div>
</section>

<style>
.page-header {
    background: var(--gradient-hero);
    color: white;
    padding: 140px 0 60px;
    text-align: center;
}

.page-header h1 {
    color: white;
    margin-bottom: 16px;
}

.page-header p {
    max-width: 600px;
    margin: 0 auto;
    opacity: 0.9;
}

.blog-layout {
    display: grid;
    grid-template-columns: 1fr 300px;
    gap: 40px;
}

.blog-page .blog-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 30px;
}

.blog-category {
    display: inline-block;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
    color: var(--primary);
    background: rgba(8, 145, 178, 0.1);
    padding: 4px 10px;
    border-radius: 4px;
    margin-bottom: 8px;
}

/* Pagination */
.pagination {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 16px;
    margin-top: 50px;
}

.pagination-numbers {
    display: flex;
    gap: 8px;
}

.pagination-numbers a,
.pagination-current {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 8px;
    font-weight: 500;
}

.pagination-numbers a {
    background: var(--bg-light);
    color: var(--text-primary);
}

.pagination-numbers a:hover {
    background: var(--primary);
    color: white;
}

.pagination-current {
    background: var(--primary);
    color: white;
}

.pagination-prev,
.pagination-next {
    color: var(--primary);
    font-weight: 500;
}

/* Sidebar */
.sidebar-widget {
    background: var(--bg-light);
    padding: 24px;
    border-radius: var(--radius-lg);
    margin-bottom: 24px;
}

.sidebar-widget h3 {
    font-size: 1.125rem;
    margin-bottom: 16px;
}

.category-list li {
    margin-bottom: 12px;
}

.category-list a {
    display: flex;
    justify-content: space-between;
    color: var(--text-secondary);
}

.category-list a:hover,
.category-list a.active {
    color: var(--primary);
}

.category-list .count {
    color: var(--text-light);
    font-size: 0.875rem;
}

.search-form {
    display: flex;
    gap: 8px;
}

.search-form input {
    flex: 1;
    padding: 12px 16px;
    border: 1px solid var(--border-light);
    border-radius: var(--radius);
}

.search-form button {
    padding: 12px;
    background: var(--primary);
    color: white;
    border-radius: var(--radius);
}

.sidebar-cta {
    background: var(--gradient-primary);
    color: white;
}

.sidebar-cta h3 {
    color: white;
}

.sidebar-cta p {
    opacity: 0.9;
    margin-bottom: 16px;
}

.sidebar-cta .btn-primary {
    background: white;
    color: var(--primary);
}

.no-posts {
    text-align: center;
    padding: 60px;
    background: var(--bg-light);
    border-radius: var(--radius-lg);
}

@media (max-width: 1024px) {
    .blog-layout {
        grid-template-columns: 1fr;
    }
    
    .blog-sidebar {
        order: -1;
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
    }
    
    .sidebar-widget {
        margin-bottom: 0;
    }
}

@media (max-width: 768px) {
    .blog-page .blog-grid {
        grid-template-columns: 1fr;
    }
    
    .blog-sidebar {
        grid-template-columns: 1fr;
    }
}
</style>

<?php View::partial('footer'); ?>
