<?php
/**
 * Admin Header
 */

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Admin' ?> - Dr. Özgür Oktay Nar</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/admin/assets/css/admin.css">
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <a href="/admin/" class="logo">
                    <span class="logo-icon">🏥</span>
                    <span class="logo-text">Dr. Özgür</span>
                </a>
            </div>
            
            <nav class="sidebar-nav">
                <ul>
                    <li class="<?= $currentPage === 'index' ? 'active' : '' ?>">
                        <a href="/admin/">
                            <span class="nav-icon">📊</span>
                            Dashboard
                        </a>
                    </li>
                    
                    <li class="nav-section">İçerik</li>
                    
                    <li class="<?= $currentPage === 'posts' ? 'active' : '' ?>">
                        <a href="/admin/posts.php">
                            <span class="nav-icon">📝</span>
                            Yazılar
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'pages' ? 'active' : '' ?>">
                        <a href="/admin/pages.php">
                            <span class="nav-icon">📄</span>
                            Sayfalar
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'services' ? 'active' : '' ?>">
                        <a href="/admin/services.php">
                            <span class="nav-icon">🩺</span>
                            Hizmetler
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'categories' ? 'active' : '' ?>">
                        <a href="/admin/categories.php">
                            <span class="nav-icon">📁</span>
                            Kategoriler
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'media' ? 'active' : '' ?>">
                        <a href="/admin/media.php">
                            <span class="nav-icon">🖼️</span>
                            Medya
                        </a>
                    </li>
                    
                    <li class="nav-section">AI & Otomasyon</li>
                    
                    <li class="<?= $currentPage === 'ai-content' ? 'active' : '' ?>">
                        <a href="/admin/ai-content.php">
                            <span class="nav-icon">🤖</span>
                            AI İçerikler
                            <?php 
                            $pending = $db->getValue("SELECT COUNT(*) FROM n8n_content_queue WHERE status = 'pending'");
                            if ($pending > 0): 
                            ?>
                                <span class="badge"><?= $pending ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'n8n' ? 'active' : '' ?>">
                        <a href="/admin/n8n.php">
                            <span class="nav-icon">⚡</span>
                            n8n Entegrasyonu
                        </a>
                    </li>
                    
                    <li class="nav-section">SEO & Analiz</li>
                    
                    <li class="<?= $currentPage === 'seo' ? 'active' : '' ?>">
                        <a href="/admin/seo.php">
                            <span class="nav-icon">🔍</span>
                            SEO Ayarları
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'analytics' ? 'active' : '' ?>">
                        <a href="/admin/analytics.php">
                            <span class="nav-icon">📈</span>
                            Analytics
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'redirects' ? 'active' : '' ?>">
                        <a href="/admin/redirects.php">
                            <span class="nav-icon">↪️</span>
                            Yönlendirmeler
                        </a>
                    </li>
                    
                    <li class="nav-section">Entegrasyonlar</li>
                    
                    <li class="<?= $currentPage === 'reviews' ? 'active' : '' ?>">
                        <a href="/admin/reviews.php">
                            <span class="nav-icon">⭐</span>
                            Google Yorumlar
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'videos' ? 'active' : '' ?>">
                        <a href="/admin/videos.php">
                            <span class="nav-icon">🎬</span>
                            YouTube Videolar
                        </a>
                    </li>
                    
                    <li class="nav-section">Sistem</li>
                    
                    <li class="<?= $currentPage === 'menus' ? 'active' : '' ?>">
                        <a href="/admin/menus.php">
                            <span class="nav-icon">📋</span>
                            Menüler
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'settings' ? 'active' : '' ?>">
                        <a href="/admin/settings.php">
                            <span class="nav-icon">⚙️</span>
                            Ayarlar
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'backup' ? 'active' : '' ?>">
                        <a href="/admin/backup.php">
                            <span class="nav-icon">💾</span>
                            Yedekleme
                        </a>
                    </li>
                    
                    <li class="<?= $currentPage === 'users' ? 'active' : '' ?>">
                        <a href="/admin/users.php">
                            <span class="nav-icon">👥</span>
                            Kullanıcılar
                        </a>
                    </li>
                </ul>
            </nav>
            
            <div class="sidebar-footer">
                <a href="/" target="_blank" class="view-site">
                    🌐 Siteyi Görüntüle
                </a>
            </div>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Top Bar -->
            <header class="topbar">
                <button class="sidebar-toggle" onclick="document.body.classList.toggle('sidebar-collapsed')">
                    ☰
                </button>
                
                <div class="topbar-right">
                    <div class="user-menu">
                        <span class="user-name"><?= htmlspecialchars($_SESSION['admin_name'] ?? 'Admin') ?></span>
                        <div class="user-dropdown">
                            <a href="/admin/profile.php">👤 Profil</a>
                            <a href="/admin/logout.php">🚪 Çıkış</a>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Page Content -->
            <div class="page-content">
                <?php if ($pageTitle): ?>
                    <div class="page-header">
                        <h1><?= htmlspecialchars($pageTitle) ?></h1>
                    </div>
                <?php endif; ?>
                
                <?php if (hasFlash('success')): ?>
                    <div class="alert alert-success"><?= getFlash('success') ?></div>
                <?php endif; ?>
                
                <?php if (hasFlash('error')): ?>
                    <div class="alert alert-error"><?= getFlash('error') ?></div>
                <?php endif; ?>
