# 🏥 Dr. Özgür Oktay Nar - PHP CMS

WordPress Cliniq tema klonu - Saf PHP ile geliştirilmiş özel CMS.

## 🚀 Hızlı Kurulum

### 1. Hozzt cPanel'de Veritabanı Oluştur

1. cPanel'e giriş: `http://89.252.162.138:2082/`
2. **MySQL Databases** bölümüne git
3. Yeni veritabanı oluştur: `drnar` (prefix eklenir: `onarcom_drnar`)
4. Yeni kullanıcı oluştur: `drnar` (prefix eklenir: `onarcom_drnar`)
5. Kullanıcıyı veritabanına ekle: **ALL PRIVILEGES**

### 2. Subdomain Oluştur

1. cPanel > **Subdomains**
2. Subdomain: `test`
3. Domain: `drozguroktaynar.com`
4. Document Root: `public_html/test.drozguroktaynar.com`

### 3. Dosyaları Yükle

1. Bu ZIP dosyasını `public_html/test.drozguroktaynar.com/` klasörüne yükle
2. File Manager'da **Extract** et

### 4. Kurulumu Çalıştır

1. Tarayıcıda aç: `https://test.drozguroktaynar.com/installer.php`
2. Veritabanı bilgilerini gir
3. Admin şifresini belirle
4. **Kurulumu Başlat**

### 5. WordPress Migration (Opsiyonel)

Kurulum tamamlandıktan sonra:

1. Aç: `https://test.drozguroktaynar.com/migration/migrate.php?key=migrate2024drnar`
2. Adım adım migration işlemlerini çalıştır

> ⚠️ **NOT**: Migration için Güzel Hosting MySQL'e remote erişim gerekir.
> Alternatif: WordPress DB'yi Hozzt'a phpMyAdmin ile import edin.

---

## 📁 Proje Yapısı

```
drozguroktaynar/
├── admin/              # WordPress tarzı admin panel
│   ├── assets/         # Admin CSS/JS
│   └── includes/       # Header, footer
├── api/                # REST API endpoints
│   └── webhook.php     # n8n entegrasyonu
├── includes/           # Core PHP sınıfları
│   ├── config.php      # Ayarlar (düzenle!)
│   ├── Database.php    # PDO wrapper
│   ├── Router.php      # URL routing
│   └── functions.php   # Helper fonksiyonlar
├── migration/          # WordPress migration
├── public/             # Frontend
│   └── index.php       # Ana giriş
├── themes/cliniq/      # Tema dosyaları
├── uploads/            # Yüklenen medya
├── cache/              # Önbellek
├── backups/            # Yedekler
├── logs/               # Loglar
├── database.sql        # Veritabanı şeması
└── installer.php       # Otomatik kurulum
```

---

## 🔧 Yapılandırma

`includes/config.php` dosyasını düzenle:

```php
// Veritabanı
define('DB_NAME', 'onarcom_drnar');
define('DB_USER', 'onarcom_drnar');
define('DB_PASS', 'SİFRENİZ');

// Site URL
define('SITE_URL', 'https://drozguroktaynar.com');

// API Keys (opsiyonel)
define('GOOGLE_MAPS_API_KEY', '...');
define('N8N_WEBHOOK_SECRET', '...');
```

---

## 🤖 n8n Entegrasyonu

Webhook URL: `https://site.com/api/webhook.php`

### İçerik Oluşturma (POST)

```json
{
  "action": "create_content",
  "title": "PRP Tedavisi Nedir?",
  "content": "<p>PRP tedavisi...</p>",
  "keyword": "prp tedavisi",
  "meta_title": "PRP Tedavisi | Dr. Özgür Oktay Nar",
  "meta_description": "PRP tedavisi hakkında...",
  "tags": ["prp", "ortopedi"],
  "category": "ortopedi"
}
```

### Google Yorumları Güncelle (POST)

```json
{
  "action": "update_reviews",
  "reviews": [
    {
      "id": "xyz123",
      "author_name": "Ali Yılmaz",
      "rating": 5,
      "text": "Çok memnun kaldım..."
    }
  ]
}
```

---

## 📊 Admin Panel

URL: `https://site.com/admin/`

- **Kullanıcı**: admin
- **Şifre**: Kurulumda belirlediğiniz şifre

### Özellikler:
- ✅ Blog yazıları yönetimi
- ✅ Sayfa yönetimi
- ✅ Kategori/Etiket yönetimi
- ✅ Medya kütüphanesi
- ✅ SEO ayarları
- ✅ AI içerik kuyruğu
- ✅ Google yorumları
- ✅ YouTube videoları
- ✅ n8n entegrasyonu
- ✅ Analytics dashboard
- ✅ Yedekleme sistemi

---

## 🔒 Güvenlik

1. Kurulumdan sonra `installer.php` dosyasını **SİL**
2. `migration/migrate.php` dosyasını **SİL**
3. Güçlü admin şifresi kullan
4. HTTPS kullan
5. `config.php`'deki `DEBUG_MODE`'u `false` yap

---

## 📝 Lisans

Özel kullanım için geliştirilmiştir.
Op. Dr. Özgür Oktay Nar © 2024
